/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.ow2.orchestra.cxf.OrchestraBaseCxfServlet;
import org.ow2.orchestra.env.BpelEnvironmentParser;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.pvm.internal.util.ReflectUtil;
import org.ow2.orchestra.util.Misc;

public class OrchestraCxfServlet
extends OrchestraBaseCxfServlet {
    private static final long serialVersionUID = 2528286722832028480L;
    private final JMXAgent jmxAgent = new JMXAgent();
    private static final String DEFAULT_ENV_CONFIG_FILE = "conf/environment.xml";
    private static final String DEFAULT_ENV_CONFIG_RESOURCE = "environment.xml";

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        URL envUrl = null;
        File envFile = new File(DEFAULT_ENV_CONFIG_FILE);
        if (envFile.exists()) {
            try {
                envUrl = envFile.toURL();
            }
            catch (MalformedURLException e) {
                Misc.unreachableStatement();
            }
        }
        if (envUrl == null) {
            envUrl = ReflectUtil.getResource(null, (String)DEFAULT_ENV_CONFIG_RESOURCE);
        }
        Misc.log((Level)Level.INFO, (String)"Environment will be taken from: %s", (Object[])new Object[]{envUrl});
        EnvironmentFactory envFactory = BpelEnvironmentParser.parseEnvironmentFactoryFromURL((URL)envUrl);
        this.jmxAgent.startOrchestra(envFactory);
    }

    public void destroy() {
        super.destroy();
        this.jmxAgent.stopOrchestra();
    }
}

