/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.ow2.orchestra.cxf.example.loanApprovalCamel.CamelLoanApprovalTest;
import org.ow2.orchestra.cxf.test.camel.exception.CamelExceptionTest;
import org.ow2.orchestra.cxf.test.camel.invoke.CamelInvokeTest;
import org.ow2.orchestra.cxf.test.camel.packageScan.CamelPackageScanTest;
import org.ow2.orchestra.cxf.test.camel.processor.CamelInvokeProcessorTest;
import org.ow2.orchestra.cxf.test.camel.receive.CamelReceiveTest;
import org.ow2.orchestra.cxf.test.rm.WSRMTest;
import org.ow2.orchestra.cxf.test.wsaddressing.WSATest;
import org.ow2.orchestra.test.remote.RemoteTests;
import org.ow2.orchestra.test.remote.hello2OneBinding.Hello2OneServiceTest;


/**
 * @author Guillaume Porcher
 *
 */
public class CxfTests extends TestCase {
  public static Test suite() {
    final TestSuite testSuite = new TestSuite(CxfTests.class.getName());
    // Add common remote tests
    testSuite.addTest(RemoteTests.suite());
    // This test fails with axis implementation
    testSuite.addTestSuite(Hello2OneServiceTest.class);
    // Add WS-Addressing tests
    testSuite.addTestSuite(WSATest.class);
    // Add WS-RM tests
    testSuite.addTestSuite(WSRMTest.class);
    // Add Camel tests
    testSuite.addTestSuite(CamelReceiveTest.class);
    testSuite.addTestSuite(CamelInvokeTest.class);
    testSuite.addTestSuite(CamelInvokeProcessorTest.class);
    testSuite.addTestSuite(CamelLoanApprovalTest.class);
    testSuite.addTestSuite(CamelPackageScanTest.class);
    testSuite.addTestSuite(CamelExceptionTest.class);
    return testSuite;
  }
}
