/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf.test.camel.exception;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import junit.framework.Assert;

import org.apache.camel.CamelException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;

/**
 * @author Guillaume Porcher
 */
public class CamelExceptionTest extends RemoteTestCase {
  private final String processName = "helloworld";
  /**
   * test.
   * @throws IOException
   */
  public void testCamelContextException() throws IOException {
    // Deploy the process (with the camel-context.xml file)
    final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    resources.put("camel-context.xml", Misc.getAllContentFrom(this.getClass().getResource("camel-context.xml")));
    try {
      this.deploy(this.getClass().getResource(this.processName + ".bpel"), null, resources);
      Assert.fail("deployment should fail");
    } catch (final Exception e) {
      // Check deployment failed and failure is caused by a CamelException.
      boolean hasCamelException = false;
      Throwable t = e;
      while (t != null) {
        hasCamelException = hasCamelException || t instanceof CamelException;
        t = t.getCause();
      }
      Assert.assertTrue(Misc.getStackTraceFrom(e), hasCamelException);
    }
  }
}
