/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.cxf.test.camel.invoke;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;

import junit.framework.Assert;

import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;

/**
 * Tests the Cxf Invoker with camel endpoints.
 *
 * @author Guillaume Porcher
 * @author S. Ali Tokmen
 */
public class CamelInvokeTest extends RemoteTestCase {

  private static final String PROCESS_NAME = "invokeBpel";
  private static final String PROCESS_NAMESPACE = "http://orchestra.ow2.org/invokeBpel";
  private static final QName PROCESS_QNAME =
    new QName(CamelInvokeTest.PROCESS_NAMESPACE, CamelInvokeTest.PROCESS_NAME);
  private static final QName INVOKE_SERVICE_QNAME =
    new QName("tns:http://orchestra.ow2.org/invokeService/invokeService", "invokeService");


  public void testCamelInvoker() throws Exception {
    final Thread t = null;

    // Deploy the process (with the camel-context.xml file)
    Map<String, byte[]> resources = new HashMap<String, byte[]>();
    byte[] camelContextXml = Misc.getAllContentFrom(this.getClass().getResource("camel-context-invokeBpel.xml"));
    resources.put("camel-context.xml", camelContextXml);
    this.deploy(this.getClass().getResource("invokeBpel.bpel"), null, resources);

    // Deploy invokeServiceProcess
    resources = new HashMap<String, byte[]>();
    camelContextXml = Misc.getAllContentFrom(this.getClass().getResource("camel-context-invokeService.xml"));
    resources.put("camel-context.xml", camelContextXml);
    this.deploy(this.getClass().getResource("invokeService.bpel"), null, resources);

    try {
      final String random = UUID.randomUUID().toString();

      final String part =
        "<invokeBpelMessage xmlns='" + CamelInvokeTest.PROCESS_NAMESPACE + "'>" + random + "</invokeBpelMessage>";

      final String processEndpoint = this.getDefaultEndpoint("invokeBpelPort");

      final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage(CamelInvokeTest.PROCESS_NAMESPACE, part);
      final SOAPMessage responded = SOAPUtil.call(request, processEndpoint);

      Assert.assertNotNull(responded);
      Assert.assertFalse(responded.getSOAPBody().hasFault());
      final SOAPBodyElement result = this.getSOAPBodyElement(responded);

      final String expected = XmlUtil.toString(
        XmlUtil.getDocumentFromString(
          "<invokeBpelMessage xmlns=\"" + CamelInvokeTest.PROCESS_NAMESPACE + "\">hello " + random + "</invokeBpelMessage>",
          false)
      );
      Assert.assertEquals(expected, XmlUtil.toString(result));
    } finally {
      if (t != null) {
        t.interrupt();
      }
    }

    this.undeploy(CamelInvokeTest.PROCESS_QNAME);
    this.undeploy(CamelInvokeTest.INVOKE_SERVICE_QNAME);

  }

}
