/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.cxf.test.camel.packageScan;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;

import junit.framework.Assert;

import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;

/**
 * Tests the Cxf Invoker with camel endpoints and a user defined processor class.
 *
 * @author Guillaume Porcher
 * @author S. Ali Tokmen
 */
public class CamelPackageScanTest extends RemoteTestCase {

  private static final String PROCESS_NAME = "invokeBpel";
  private static final String PROCESS_NAMESPACE = "http://orchestra.ow2.org/invokeBpel";
  private static final QName PROCESS_QNAME =
    new QName(CamelPackageScanTest.PROCESS_NAMESPACE, CamelPackageScanTest.PROCESS_NAME);


  public void testRouteWithExternalRouteBuilder() throws Exception {
    final Thread t = null;

    // Deploy the process (with the camel-context.xml file)
    final Map<String, byte[]> resources = new HashMap<String, byte[]>();
    final byte[] camelContextXml = Misc.getAllContentFrom(this.getClass().getResource("camel-context.xml"));
    resources.put("camel-context.xml", camelContextXml);

    final byte[] beansClassBytes =
      Misc.getAllContentFrom(this.getClass().getResource(TestProcessor.class.getSimpleName() + ".class"));
    resources.put(TestProcessor.class.getName().replace(".", "/") + ".class", beansClassBytes);
    resources.put(TestRouteBuilder.class.getName().replace(".", "/") + ".class",
        Misc.getAllContentFrom(this.getClass().getResource(TestRouteBuilder.class.getSimpleName() + ".class")));
    this.deploy(this.getClass().getResource("invokeBpel.bpel"), null, resources);


    try {
      final String random = UUID.randomUUID().toString();

      final String part =
        "<invokeBpelMessage xmlns='" + CamelPackageScanTest.PROCESS_NAMESPACE + "'>" + random + "</invokeBpelMessage>";

      final String processEndpoint = this.getDefaultEndpoint("invokeBpelPort");

      final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage(CamelPackageScanTest.PROCESS_NAMESPACE, part);
      final SOAPMessage responded = SOAPUtil.call(request, processEndpoint);

      Assert.assertNotNull(responded);
      Assert.assertFalse(responded.getSOAPBody().hasFault());
      final SOAPBodyElement result = this.getSOAPBodyElement(responded);

      final String expected = XmlUtil.toString(
        XmlUtil.getDocumentFromString(
          "<invokeBpelMessage xmlns='" + CamelPackageScanTest.PROCESS_NAMESPACE + "'>hello " + random + "</invokeBpelMessage>",
          false
        )
      );
      Assert.assertEquals(expected, XmlUtil.toString(result));
    } finally {
      if (t != null) {
        t.interrupt();
      }
    }

    this.undeploy(CamelPackageScanTest.PROCESS_QNAME);
  }

}
