/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf.test.camel.processor;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * @author Guillaume Porcher
 *
 */
public class TestProcessor implements Processor {

  public Document call(final Document input) {
    final NodeList nl = input.getElementsByTagName("argument");
    final Node node = nl.item(0);
    final String text = node.getTextContent();
    final Node newNode = input.renameNode(node, null, "result");
    newNode.setTextContent("hello " + text);

    return input;
  }

  public void process(final Exchange exchange) throws Exception {
    final Document out = this.call(exchange.getIn().getBody(Document.class));
    exchange.getOut().setBody(out);
  }
}
