/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf.test.camel.receive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CamelReceiveTest
extends RemoteTestCase {
    private final String processName = "helloworld";
    private final String processNamespace = "http://example.com/helloworld";

    public void testCamelFileHelloworld() {
        try {
            QName processQName = new QName(this.processNamespace, this.processName);
            File tmpDir = Misc.createTempFile((String)"orchCamel", null, null);
            tmpDir.delete();
            tmpDir.mkdir();
            File inDir = new File(tmpDir, "in");
            inDir.mkdir();
            File outDir = new File(tmpDir, "out");
            outDir.mkdir();
            byte[] camelContextXml = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource("camel-context.xml"));
            camelContextXml = new String(camelContextXml).replace("${fileUrl}", "file://" + inDir.getAbsolutePath() + "?noop=true").getBytes();
            camelContextXml = new String(camelContextXml).replace("${outFileUrl}", "file://" + outDir.getAbsolutePath()).getBytes();
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            resources.put("camel-context.xml", camelContextXml);
            this.deploy(((Object)((Object)this)).getClass().getResource(this.processName + ".bpel"), null, resources);
            this.callService(tmpDir, inDir, outDir, "Dupont");
            this.callService(tmpDir, inDir, outDir, "Toto");
            outDir.delete();
            inDir.delete();
            tmpDir.delete();
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void callService(File tmpDir, File inDir, File outDir, String name) throws Exception {
        String part = "<submit xmlns='http://example.com/helloworld'><st>" + name + "</st></submit>";
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/helloworld/submit", (String)part);
        File inFile = new File(inDir, "request-" + name);
        FileOutputStream outputStream = new FileOutputStream(inFile);
        request.writeTo((OutputStream)outputStream);
        outputStream.close();
        while (outDir.listFiles().length == 0) {
            Thread.sleep(200L);
        }
        Thread.sleep(1000L);
        File[] outFiles = outDir.listFiles();
        Assert.assertEquals((int)1, (int)outFiles.length);
        FileInputStream fileInputStream = new FileInputStream(outFiles[0]);
        SOAPMessage response = MessageFactory.newInstance().createMessage(null, (InputStream)fileInputStream);
        fileInputStream.close();
        if (response != null) {
            SOAPBodyElement result = this.getSOAPBodyElement(response);
            this.checkReturn(result, name);
        } else {
            Assert.assertTrue((String)"No return available", (boolean)false);
        }
        outFiles[0].delete();
        inFile.delete();
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"submit", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.processNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Assert.assertNotNull((Object)XmlUtil.element((Element)result));
        Element st = XmlUtil.element((Element)result);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.processNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)("hello " + name), (String)text.getData());
    }
}

