/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf.example.loanApprovalCamel;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

public class RiskAssessmentBindingImpl
implements Processor {
    public String check(String firstName, String name, long amount) throws RemoteException {
        if ("Dupont".equals(name) || "McDonalds".equals(name)) {
            return "medium";
        }
        if ("Kent".equals(name) || "Martin".equals(name)) {
            return "high";
        }
        return "low";
    }

    public void process(Exchange exchange) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage inMessage = messageFactory.createMessage(null, (InputStream)exchange.getIn().getMandatoryBody(InputStream.class));
        Iterator it = inMessage.getSOAPBody().getChildElements();
        SOAPBodyElement result = null;
        while (it.hasNext()) {
            Node item = (Node)it.next();
            if (!(item instanceof SOAPBodyElement)) continue;
            if (result != null) {
                throw new OrchestraRuntimeException("response.soapBody.children has more than one child");
            }
            result = (SOAPBodyElement)item;
        }
        if (result == null) {
            throw new OrchestraRuntimeException("response.soapBody.children has no child");
        }
        String firstName = XmlUtil.element(result, (String)"firstName").getTextContent();
        String name = XmlUtil.element(result, (String)"name").getTextContent();
        long amount = Long.parseLong(XmlUtil.element((Element)result, (String)"amount").getTextContent());
        String level = this.check(firstName, name, amount);
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope enveloppe = soapPart.getEnvelope();
        enveloppe.addNamespaceDeclaration("env", "http://schemas.xmlsoap.org/soap/envelope/");
        SOAPBody soapBody = enveloppe.getBody();
        SOAPElement levelElement = soapBody.addChildElement("result").addChildElement("level");
        levelElement.setTextContent(level);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        exchange.getOut().setBody((Object)byteArrayOutputStream.toByteArray());
    }
}

