/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf.test.rm;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WSRMTest
extends RemoteTestCase {
    private static final String WS_ADD_2004_ANONYMOUS = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
    private final String helloProcessName = "helloworld";
    private final String helloProcessNamespace = "http://orchestra.ow2.org/cxf/test/wsrm";
    private final String invokerProcessName = "invoker";
    private final String invokerProcessNamespace = "http://orchestra.ow2.org/cxf/test/wsrm/invoker";
    private static final String WS_RM_NS_URI = "http://schemas.xmlsoap.org/ws/2005/02/rm";

    public void testHelloworldWithRM() {
        try {
            SOAPBodyElement result;
            QName processQName = new QName(this.helloProcessNamespace, this.helloProcessName);
            this.deploy(this.helloProcessName);
            String part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsrm'><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsrm/helloworldPT/submitRequest", (String)part);
            String endpoint = this.getDefaultEndpoint("helloworldPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result2 = this.getSOAPBodyElement(response);
                Assert.assertTrue((boolean)(result2 instanceof SOAPFault));
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<wsrm:CreateSequence xmlns:wsrm='http://schemas.xmlsoap.org/ws/2005/02/rm' xmlns:wsa='http://schemas.xmlsoap.org/ws/2004/08/addressing'><wsrm:AcksTo><wsa:Address>http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous</wsa:Address></wsrm:AcksTo><wsrm:Offer><wsrm:Identifier>" + Misc.getRandomString((int)22) + "</wsrm:Identifier></wsrm:Offer>" + "</wsrm:CreateSequence>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence", (String)part);
            request.getSOAPHeader().addNamespaceDeclaration("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            request.getSOAPHeader().addChildElement("To", "wsa").addTextNode(endpoint);
            request.getSOAPHeader().addChildElement("ReplyTo", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            request.getSOAPHeader().addChildElement("From", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            SOAPElement wsaAction = request.getSOAPHeader().addChildElement("Action", "wsa");
            wsaAction.addTextNode("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence");
            SOAPElement wsaMessageId = request.getSOAPHeader().addChildElement("MessageID", "wsa");
            wsaMessageId.addTextNode(Misc.getRandomString((int)42));
            request.saveChanges();
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            String sequenceIdentifier = null;
            if (response != null) {
                SOAPBodyElement result3 = this.getSOAPBodyElement(response);
                Assert.assertNotNull((Object)result3);
                Assert.assertEquals((String)XmlUtil.toString((Node)result3), (String)"CreateSequenceResponse", (String)result3.getElementName().getLocalName());
                Assert.assertEquals((String)XmlUtil.toString((Node)result3), (String)WS_RM_NS_URI, (String)result3.getElementName().getURI());
                sequenceIdentifier = XmlUtil.element((Element)result3, (String)WS_RM_NS_URI, (String)"Identifier").getTextContent();
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsrm'><st>Toto</st></submit>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsrm/helloworldPT/submitRequest", (String)part);
            request.getSOAPHeader().addNamespaceDeclaration("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            request.getSOAPHeader().addNamespaceDeclaration("wsrm", WS_RM_NS_URI);
            request.getSOAPHeader().addChildElement("To", "wsa").addTextNode(endpoint);
            request.getSOAPHeader().addChildElement("ReplyTo", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            request.getSOAPHeader().addChildElement("From", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            wsaAction = request.getSOAPHeader().addChildElement("Action", "wsa");
            wsaAction.addTextNode("http://orchestra.ow2.org/cxf/test/wsrm/helloworldPT/submitRequest");
            wsaMessageId = request.getSOAPHeader().addChildElement("MessageID", "wsa");
            wsaMessageId.addTextNode(Misc.getRandomString((int)42));
            SOAPElement rmSequence = request.getSOAPHeader().addChildElement("Sequence", "wsrm");
            rmSequence.addChildElement("Identifier", "wsrm").addTextNode(sequenceIdentifier);
            rmSequence.addChildElement("MessageNumber", "wsrm").addTextNode("1");
            request.saveChanges();
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                this.checkReturn(result, "Toto");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsrm'><st>Titi</st></submit>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsrm/helloworldPT/submitRequest", (String)part);
            request.getSOAPHeader().addNamespaceDeclaration("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            request.getSOAPHeader().addNamespaceDeclaration("wsrm", WS_RM_NS_URI);
            request.getSOAPHeader().addChildElement("To", "wsa").addTextNode(endpoint);
            request.getSOAPHeader().addChildElement("ReplyTo", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            request.getSOAPHeader().addChildElement("From", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            wsaAction = request.getSOAPHeader().addChildElement("Action", "wsa");
            wsaAction.addTextNode("http://orchestra.ow2.org/cxf/test/wsrm/helloworldPT/submitRequest");
            wsaMessageId = request.getSOAPHeader().addChildElement("MessageID", "wsa");
            wsaMessageId.addTextNode(Misc.getRandomString((int)42));
            rmSequence = request.getSOAPHeader().addChildElement("Sequence", "wsrm");
            rmSequence.addChildElement("Identifier", "wsrm").addTextNode(sequenceIdentifier);
            rmSequence.addChildElement("MessageNumber", "wsrm").addTextNode("2");
            rmSequence.addChildElement("LastMessage", "wsrm");
            request.saveChanges();
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                this.checkReturn(result, "Titi");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<wsrm:TerminateSequence xmlns:wsrm='http://schemas.xmlsoap.org/ws/2005/02/rm' ><wsrm:Identifier>" + sequenceIdentifier + "</wsrm:Identifier>" + "</wsrm:TerminateSequence>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence", (String)part);
            request.getSOAPHeader().addNamespaceDeclaration("wsa", "http://schemas.xmlsoap.org/ws/2004/08/addressing");
            request.getSOAPHeader().addChildElement("To", "wsa").addTextNode(endpoint);
            request.getSOAPHeader().addChildElement("ReplyTo", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            request.getSOAPHeader().addChildElement("From", "wsa").addChildElement("Address", "wsa").addTextNode(WS_ADD_2004_ANONYMOUS);
            wsaAction = request.getSOAPHeader().addChildElement("Action", "wsa");
            wsaAction.addTextNode("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence");
            wsaMessageId = request.getSOAPHeader().addChildElement("MessageID", "wsa");
            wsaMessageId.addTextNode(Misc.getRandomString((int)42));
            request.saveChanges();
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public void testInvokerWithRM() {
        try {
            QName helloProcessQName = new QName(this.helloProcessNamespace, this.helloProcessName);
            QName invokerProcessQName = new QName(this.invokerProcessNamespace, this.invokerProcessName);
            this.deploy(this.helloProcessName);
            this.deploy(this.invokerProcessName);
            String part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsrm'><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsrm/invoker/invokerPT/submitRequest", (String)"<submit xmlns='http://orchestra.ow2.org/cxf/test/wsrm'><st>Dupont</st></submit>");
            String endpoint = this.getDefaultEndpoint("invokerPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, "Dupont");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(invokerProcessQName);
            this.undeploy(helloProcessQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"submit", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.helloProcessNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Assert.assertNotNull((Object)XmlUtil.element((Element)result));
        Element st = XmlUtil.element((Element)result);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.helloProcessNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

