/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf.test.wsaddressing;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class WSATest
extends RemoteTestCase {
    private final String helloProcessName = "helloworld";
    private final String helloProcessNamespace = "http://orchestra.ow2.org/cxf/test/wsaddressing";
    private final String invokerProcessName = "invoker";
    private final String invokerProcessNamespace = "http://orchestra.ow2.org/cxf/test/wsaddressing/invoker";

    public void testHelloworldWithAddressing() {
        try {
            QName processQName = new QName(this.helloProcessNamespace, this.helloProcessName);
            this.deploy(this.helloProcessName);
            String part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsaddressing'><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsaddressing/helloworldPT/submitRequest", (String)part);
            String endpoint = this.getDefaultEndpoint("helloworldPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                Assert.assertTrue((boolean)(result instanceof SOAPFault));
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsaddressing'><st>Toto</st></submit>";
            request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsaddressing/helloworldPT/submitRequest", (String)part);
            request.getSOAPHeader().addNamespaceDeclaration("wsa", "http://www.w3.org/2005/08/addressing");
            SOAPElement wsaAction = request.getSOAPHeader().addChildElement("Action", "wsa");
            wsaAction.addTextNode("http://orchestra.ow2.org/cxf/test/wsaddressing/helloworldPT/submitRequest");
            request.saveChanges();
            response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = (SOAPBodyElement)response.getSOAPBody().getChildElements().next();
                this.checkReturn(result, "Toto");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public void testInvokerWithAddressing() {
        try {
            QName helloProcessQName = new QName(this.helloProcessNamespace, this.helloProcessName);
            QName invokerProcessQName = new QName(this.invokerProcessNamespace, this.invokerProcessName);
            this.deploy(this.helloProcessName);
            this.deploy(this.invokerProcessName);
            String part = "<submit xmlns='http://orchestra.ow2.org/cxf/test/wsaddressing'><st>Dupont</st></submit>";
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/cxf/test/wsaddressing/invoker/invokerPT/submitRequest", (String)"<submit xmlns='http://orchestra.ow2.org/cxf/test/wsaddressing'><st>Dupont</st></submit>");
            String endpoint = this.getDefaultEndpoint("invokerPort");
            SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            if (response != null) {
                SOAPBodyElement result = this.getSOAPBodyElement(response);
                this.checkReturn(result, "Dupont");
            } else {
                Assert.assertTrue((String)"No return available", (boolean)false);
            }
            this.undeploy(invokerProcessQName);
            this.undeploy(helloProcessQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void checkReturn(SOAPBodyElement result, String name) {
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)"submit", (String)result.getElementName().getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)result), (String)this.helloProcessNamespace, (String)result.getElementName().getURI());
        Assert.assertNotNull((String)XmlUtil.toString((Node)result), (Object)result.getFirstChild());
        Assert.assertNotNull((Object)XmlUtil.element((Element)result));
        Element st = XmlUtil.element((Element)result);
        Assert.assertEquals((String)"st", (String)st.getLocalName());
        Assert.assertEquals((String)XmlUtil.toString((Node)st), (String)this.helloProcessNamespace, (String)st.getNamespaceURI());
        Assert.assertNotNull((Object)st.getFirstChild());
        Assert.assertTrue((boolean)(st.getFirstChild() instanceof Text));
        Text text = (Text)st.getFirstChild();
        Assert.assertEquals((String)name, (String)text.getData());
    }
}

