/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf.test.camel.packageScan;

import java.net.URL;
import java.util.HashMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.cxf.test.camel.packageScan.TestProcessor;
import org.ow2.orchestra.cxf.test.camel.packageScan.TestRouteBuilder;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;

public class CamelPackageScanTest
extends RemoteTestCase {
    private static final String PROCESS_NAME = "invokeBpel";
    private static final String PROCESS_NAMESPACE = "http://orchestra.ow2.org/invokeBpel";
    private static final QName PROCESS_QNAME = new QName("http://orchestra.ow2.org/invokeBpel", "invokeBpel");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRouteWithExternalRouteBuilder() throws Exception {
        Thread t = null;
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        byte[] camelContextXml = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource("camel-context.xml"));
        resources.put("camel-context.xml", camelContextXml);
        byte[] beansClassBytes = Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(TestProcessor.class.getSimpleName() + ".class"));
        resources.put(TestProcessor.class.getName().replace(".", "/") + ".class", beansClassBytes);
        resources.put(TestRouteBuilder.class.getName().replace(".", "/") + ".class", Misc.getAllContentFrom((URL)((Object)((Object)this)).getClass().getResource(TestRouteBuilder.class.getSimpleName() + ".class")));
        this.deploy(((Object)((Object)this)).getClass().getResource("invokeBpel.bpel"), null, resources);
        try {
            String random = UUID.randomUUID().toString();
            String part = "<invokeBpelMessage xmlns='http://orchestra.ow2.org/invokeBpel'>" + random + "</invokeBpelMessage>";
            String processEndpoint = this.getDefaultEndpoint("invokeBpelPort");
            SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)PROCESS_NAMESPACE, (String)part);
            SOAPMessage responded = SOAPUtil.call((SOAPMessage)request, (String)processEndpoint);
            Assert.assertNotNull((Object)responded);
            Assert.assertFalse((boolean)responded.getSOAPBody().hasFault());
            SOAPBodyElement result = this.getSOAPBodyElement(responded);
            String expected = XmlUtil.toString((Node)XmlUtil.getDocumentFromString((String)("<invokeBpelMessage xmlns='http://orchestra.ow2.org/invokeBpel'>hello " + random + "</invokeBpelMessage>"), (boolean)false));
            Assert.assertEquals((String)expected, (String)XmlUtil.toString((Node)result));
        }
        finally {
            if (t != null) {
                t.interrupt();
            }
        }
        this.undeploy(PROCESS_QNAME);
    }
}

