/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.io.IOException;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.ow2.orchestra.env.EnvFactoryRepository;

public class OrchestraCxfServletTransportFactory
extends ServletTransportFactory {
    private String context = null;

    public OrchestraCxfServletTransportFactory(Bus bus) {
        super(bus);
    }

    public Destination getDestination(EndpointInfo endpointInfo) throws IOException {
        endpointInfo.setAddress(this.removeContextFromPath(endpointInfo.getAddress()));
        return super.getDestination(endpointInfo);
    }

    private String removeContextFromPath(String path) {
        if (this.context == null) {
            Properties properties = (Properties)EnvFactoryRepository.get().get("orchestra-properties");
            this.context = "http://" + properties.getProperty("orchestra.servlet.host") + ":" + properties.getProperty("orchestra.servlet.port") + "/" + properties.getProperty("orchestra.servlet.path");
        }
        if (path.startsWith(this.context)) {
            return path.substring(this.context.length());
        }
        return path;
    }
}

