/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf;

import java.io.IOException;
import java.util.Properties;

import org.apache.cxf.Bus;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.servlet.ServletTransportFactory;
import org.ow2.orchestra.env.EnvFactoryRepository;
import org.ow2.orchestra.util.OrchestraConstants;

public class OrchestraCxfServletTransportFactory extends ServletTransportFactory {

  private String context = null;

  public OrchestraCxfServletTransportFactory(final Bus bus) {
    super(bus);
  }

  /**
   * Publish destination with an address relative to the servlet context.
   */
  @Override
  public Destination getDestination(final EndpointInfo endpointInfo) throws IOException {
    endpointInfo.setAddress(this.removeContextFromPath(endpointInfo.getAddress()));
    return super.getDestination(endpointInfo);
  }


  /**
   * Remove servlet context (e.g. http://localhost:port/context/) from request.
   * @param path
   * @return
   */
  private String removeContextFromPath(final String path) {
    if (this.context == null) {
      final Properties properties = (Properties) EnvFactoryRepository.get().get(OrchestraConstants.ORCHESTRA_PROPERTIES);
      this.context = "http://" + properties.getProperty(OrchestraConstants.SERVLET_HOST)
        + ":" + properties.getProperty(OrchestraConstants.SERVLET_PORT)
        + "/" + properties.getProperty(OrchestraConstants.SERVLET_PATH);
    }
    if (path.startsWith(this.context)) {
      return path.substring(this.context.length());
    }
    return path;
  }
}