/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.ow2.orchestra.cxf.CxfUtils;
import org.ow2.orchestra.cxf.CxfWSImpl;
import org.ow2.orchestra.cxf.OrchestraReflectionServiceFactoryBean;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.ws.WSDeployer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfDeployer
extends WSDeployer {
    public static final Bus CXF_BUS = BusFactory.getDefaultBus();
    public static final String WSDL_FILE_NAME = ".wsdl";
    private static Logger log = Logger.getLogger(Deployment.class.getName());
    private static File webAppTmpDir;
    private final File servicesDir;
    private final BpelProcess bpelProcess;

    public CxfDeployer(BpelProcess bpelProcess) {
        super(bpelProcess.getUUID());
        this.bpelProcess = bpelProcess;
        this.servicesDir = this.getServicesDir();
    }

    protected String checkOperationStyle(String operationStyle) {
        if (operationStyle == null) {
            return "Style attribute of this operation must be specified";
        }
        if (!operationStyle.equals("document") && !operationStyle.equals("rpc")) {
            return "Style attribute of this operation must be : document or rpc";
        }
        return null;
    }

    protected String checkOperationType(OperationType operationType) {
        if (!operationType.equals(OperationType.REQUEST_RESPONSE) && !operationType.equals(OperationType.ONE_WAY)) {
            return "Operation type : " + operationType + " is not supported. Please use one of : " + OperationType.ONE_WAY + "/" + OperationType.REQUEST_RESPONSE;
        }
        return null;
    }

    protected String checkSoapVersion(ExtensibilityElement soapBinding) {
        if (!(soapBinding instanceof SOAPBinding) && !(soapBinding instanceof SOAP12Binding)) {
            return "Supported Soap Version are http://schemas.xmlsoap.org/wsdl/soap//http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return null;
    }

    protected String checkTransport(ExtensibilityElement soapBinding) {
        String transportUri = "";
        if (soapBinding instanceof SOAPBinding) {
            transportUri = ((SOAPBinding)soapBinding).getTransportURI();
        } else if (soapBinding instanceof SOAP12Binding) {
            transportUri = ((SOAP12Binding)soapBinding).getTransportURI();
        }
        if (!"http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
            return "Transport URI : " + transportUri + " is not supported. Please use " + "http://schemas.xmlsoap.org/soap/http";
        }
        return null;
    }

    protected String checkUse(ExtensibilityElement element) {
        String use = "";
        if (element instanceof SOAPBody) {
            use = ((SOAPBody)element).getUse();
        } else if (element instanceof SOAP12Body) {
            use = ((SOAP12Body)element).getUse();
        } else if (element instanceof SOAPFault) {
            use = ((SOAPFault)element).getUse();
        } else if (element instanceof SOAP12Fault) {
            use = ((SOAP12Fault)element).getUse();
        }
        if (!"literal".equals(use)) {
            return "Use : " + use + " is not supported. Please use " + "literal";
        }
        return null;
    }

    protected String checkSoapBody(ExtensibilityElement soapBody) {
        List parts = null;
        if (soapBody instanceof SOAPBody) {
            parts = ((SOAPBody)soapBody).getParts();
        } else if (soapBody instanceof SOAP12Body) {
            parts = ((SOAP12Body)soapBody).getParts();
        }
        if (parts != null) {
            return "SoapBody is using parts attribute which is not currently supported.";
        }
        return null;
    }

    protected String checkSoapFault(ExtensibilityElement soapFault) {
        String name = null;
        if (soapFault instanceof SOAPFault) {
            name = ((SOAPFault)soapFault).getName();
        } else if (soapFault instanceof SOAP12Fault) {
            name = ((SOAP12Fault)soapFault).getName();
        }
        if (name == null) {
            return "SoapFault is not specifying fault name which is not currently supported.";
        }
        return null;
    }

    protected void deployServices(List<javax.wsdl.Service> services) {
        for (javax.wsdl.Service service : services) {
            File wsdlFile = this.createWsdlFile(service);
            QName serviceQName = service.getQName();
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                QName endpointQName = new QName(serviceQName.getNamespaceURI(), port.getName());
                ServerFactoryBean svrBean = new ServerFactoryBean();
                svrBean.setBus(CXF_BUS);
                String endpointURL = this.getAddressFromPort(port);
                if (endpointURL != null) {
                    svrBean.setAddress(endpointURL);
                } else {
                    svrBean.setAddress("/" + port.getName());
                }
                svrBean.setServiceName(serviceQName);
                try {
                    WSDLServiceFactory wsdlServiceFactory = new WSDLServiceFactory(CXF_BUS, wsdlFile.toURI().toURL().toExternalForm(), serviceQName);
                    wsdlServiceFactory.setEndpointName(endpointQName);
                    Service cxfService = wsdlServiceFactory.create();
                    for (OperationInfo opInfo : cxfService.getEndpointInfo(endpointQName).getInterface().getOperations()) {
                        opInfo.setUnwrappedOperation(null);
                    }
                    QName portTypeQname = port.getBinding().getPortType().getQName();
                    OrchestraReflectionServiceFactoryBean rsfb = new OrchestraReflectionServiceFactoryBean(portTypeQname, cxfService);
                    rsfb.setServiceName(serviceQName);
                    rsfb.setEndpointName(endpointQName);
                    rsfb.setInvoker(new CxfWSImpl(port.getBinding().getPortType(), this.processUUID));
                    svrBean.setServiceFactory((ReflectionServiceFactoryBean)rsfb);
                }
                catch (MalformedURLException e) {
                    throw new OrchestraRuntimeException((Throwable)e);
                }
                svrBean.setStart(false);
                Server server = svrBean.create();
                CxfUtils.setUpOrchestraInterceptors(server.getEndpoint());
                server.start();
            }
        }
    }

    protected void undeployServices(List<javax.wsdl.Service> services) {
        ServerRegistry serverRegistry = (ServerRegistry)CXF_BUS.getExtension(ServerRegistry.class);
        for (javax.wsdl.Service service : services) {
            List servers = serverRegistry.getServers();
            if (servers == null) continue;
            for (Server server : new ArrayList(servers)) {
                if (!server.getEndpoint().getService().getName().equals(service.getQName())) continue;
                server.stop();
            }
        }
    }

    private File getWsdlFile(QName serviceQName) {
        return new File(this.getWsdlFilesDir(serviceQName.getNamespaceURI()) + File.separator + serviceQName.getLocalPart() + WSDL_FILE_NAME);
    }

    private String getWsdlFilesDir(String wsdlTargetnamespace) {
        String wsdlFilesDir = this.servicesDir + File.separator + CxfDeployer.getDirectoryFromPackage(CxfDeployer.getPackageFromNamespace(wsdlTargetnamespace));
        return wsdlFilesDir;
    }

    private static synchronized File getWStempDir() {
        if (webAppTmpDir == null) {
            try {
                File tmpDir = new File(System.getProperty("java.io.tmpdir"));
                if (!tmpDir.exists() && !tmpDir.mkdirs()) {
                    throw new IOException("Cannot create the temporary directory '" + tmpDir.getAbsolutePath() + "'.");
                }
                webAppTmpDir = File.createTempFile("orchWS-Repo-", null, null);
                webAppTmpDir.delete();
                if (!webAppTmpDir.mkdirs()) {
                    throw new IOException("Cannot create the temporary directory '" + webAppTmpDir + "'.");
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("webAppTmpDir created : " + webAppTmpDir.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Error creating " + webAppTmpDir, (Throwable)e);
            }
        }
        return webAppTmpDir;
    }

    synchronized void resetServiceDir() {
        if (this.servicesDir != null) {
            Misc.deleteDir((File)this.servicesDir);
        }
    }

    private File getServicesDir() {
        String packag = CxfDeployer.getPackageFromNamespace(this.bpelProcess.getName());
        return new File(CxfDeployer.getWStempDir() + File.separator + packag + "__" + this.bpelProcess.getName());
    }

    public static String getPackageFromNamespace(String ns) {
        String packag = PackageUtils.getPackageNameByNameSpaceURI((String)ns);
        return packag;
    }

    public static String getDirectoryFromPackage(String packag) {
        String dir = packag.replace('.', File.separatorChar);
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createWsdlFile(Definition wsdlDefinition, File wsdlDir) {
        try {
            Types types;
            Map imports = wsdlDefinition.getImports();
            if (!imports.isEmpty()) {
                for (List l : imports.values()) {
                    for (Import impor : l) {
                        Definition importedDefinition = impor.getDefinition();
                        File importFile = this.createWsdlFile(importedDefinition, wsdlDir);
                        impor.setLocationURI(importFile.getName());
                    }
                }
            }
            if ((types = wsdlDefinition.getTypes()) != null) {
                for (ExtensibilityElement elt : types.getExtensibilityElements()) {
                    if (!(elt instanceof Schema)) continue;
                    Schema schema = (Schema)elt;
                    this.createImportedXsds(wsdlDir, schema);
                }
            }
            File wsdlFile = File.createTempFile("generated", WSDL_FILE_NAME, wsdlDir);
            FileOutputStream fos = new FileOutputStream(wsdlFile);
            try {
                WsdlUtil.writeWsdl((Definition)wsdlDefinition, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            return wsdlFile.getAbsoluteFile();
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private void createImportedXsds(File wsdlDir, Schema schema) {
        File refFile;
        NodeList importsNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < importsNl.getLength(); ++i) {
            Element importElt = (Element)importsNl.item(i);
            if (!importElt.hasAttribute("schemaLocation")) continue;
            Map schemaImportsMap = schema.getImports();
            List schemaImports = (List)schemaImportsMap.get(importElt.getAttribute("namespace"));
            for (SchemaImport schemaImport : schemaImports) {
                if (schemaImport.getSchemaLocationURI() == null || !schemaImport.getSchemaLocationURI().equals(importElt.getAttribute("schemaLocation"))) continue;
                refFile = this.createXsdFile(schemaImport.getReferencedSchema(), wsdlDir);
                schemaImport.setSchemaLocationURI(refFile.toURI().toString());
                importElt.setAttribute("schemaLocation", refFile.toURI().toString());
            }
        }
        NodeList includeNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
        for (int i = 0; i < includeNl.getLength(); ++i) {
            Element includeElt = (Element)includeNl.item(i);
            if (!includeElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getIncludes()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(includeElt.getAttribute("schemaLocation"))) continue;
                File refFile2 = this.createXsdFile(schemaReference.getReferencedSchema(), wsdlDir);
                schemaReference.setSchemaLocationURI(refFile2.toURI().toString());
                includeElt.setAttribute("schemaLocation", refFile2.toURI().toString());
            }
        }
        NodeList redefinesNl = schema.getElement().getOwnerDocument().getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "redefine");
        for (int i = 0; i < redefinesNl.getLength(); ++i) {
            Element redefineElt = (Element)redefinesNl.item(i);
            if (!redefineElt.hasAttribute("schemaLocation")) continue;
            for (SchemaReference schemaReference : schema.getRedefines()) {
                if (schemaReference.getSchemaLocationURI() == null || !schemaReference.getSchemaLocationURI().equals(redefineElt.getAttribute("schemaLocation"))) continue;
                refFile = this.createXsdFile(schemaReference.getReferencedSchema(), wsdlDir);
                schemaReference.setSchemaLocationURI(refFile.toURI().toString());
                redefineElt.setAttribute("schemaLocation", refFile.toURI().toString());
            }
        }
    }

    private File createXsdFile(Schema schema, File wsdlDir) {
        this.createImportedXsds(wsdlDir, schema);
        try {
            File xsdFile = File.createTempFile("generated", ".xsd", wsdlDir);
            Element schemaElement = schema.getElement();
            XmlUtil.writeXmlFile((Document)schemaElement.getOwnerDocument(), (File)xsdFile);
            return xsdFile;
        }
        catch (IOException e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private File createWsdlFile(javax.wsdl.Service service) {
        File wsdlFile = this.getWsdlFile(service.getQName());
        File wsdlDir = wsdlFile.getParentFile();
        wsdlDir.mkdirs();
        Definition wsdlDefinition = this.bpelProcess.getWsdlInfos().extractServiceWsdlDefinition(service);
        return this.createWsdlFile(wsdlDefinition, wsdlDir);
    }

    protected void checkWSEngineIsAvailable() {
    }
}

