/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.common.util.Base64Utility;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.ow2.orchestra.cxf.CxfMessageUtil;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.MessageCarrier;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.ReceivingService;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CxfWSImpl
implements Invoker {
    private static Logger log = Logger.getLogger(CxfWSImpl.class.getName());
    private final PortType portType;
    private final ProcessDefinitionUUID processUUID;

    public CxfWSImpl(PortType portType, ProcessDefinitionUUID processUUID) {
        this.processUUID = processUUID;
        this.portType = portType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DOMSource[] invoke(Exchange exchange, Object payload) {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfWSImpl.class.getClassLoader());
        try {
            BindingOperationInfo boi = (BindingOperationInfo)exchange.get(BindingOperationInfo.class);
            OperationInfo operationInfo = boi.getOperationInfo();
            SoapBindingInfo bindingInfo = (SoapBindingInfo)boi.getBinding();
            String operationStyle = bindingInfo.getStyle(operationInfo);
            if (operationStyle == null) {
                operationStyle = bindingInfo.getStyle();
            }
            String operationName = operationInfo.getName().getLocalPart();
            Operation operation = CxfWSImpl.getOperation(this.portType, operationName);
            Message inMessage = exchange.getInMessage();
            List msgContent = (List)inMessage.getContent(List.class);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Entering WS Implementation, process = " + this.processUUID + ", PT = " + this.portType.getQName() + ", op = " + operationName + ", opStyle = " + operationStyle);
                for (DOMSource obj : msgContent) {
                    Document doc = (Document)obj.getNode();
                    log.fine("body = " + XmlUtil.toString((Node)doc));
                }
            }
            javax.wsdl.Message inputMessage = operation.getInput().getMessage();
            MessageVariable incomingMessage = CxfMessageUtil.cxfToOrchestraMessage(msgContent.toArray(new DOMSource[msgContent.size()]), operationStyle, inputMessage);
            if (log.isLoggable(Level.FINE)) {
                log.fine("incomingMessage = " + incomingMessage);
            }
            MessageCarrier messageCarrier = null;
            if (operation.getOutput() != null) {
                messageCarrier = new MessageCarrier();
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Doing call to receiver, messageCarrier = " + messageCarrier);
            }
            OperationKey operationKey = new OperationKey(this.processUUID, this.portType.getQName(), operationName);
            BpelExecution instance = ReceivingService.handle((MessageVariable)incomingMessage, (OperationKey)operationKey, (MessageCarrier)messageCarrier);
            if (log.isLoggable(Level.FINE)) {
                log.fine("call to receiver done. Instance = " + instance);
            }
            if (operation.getOutput() != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("This operation has an output, waiting for messageCarrier...");
                }
                MessageVariable responseMessage = messageCarrier.getMessage();
                QName faultQName = messageCarrier.getFaultQName();
                Object elementsReturned = null;
                if (faultQName != null) {
                    Fault faultDef = operation.getFault(faultQName.getLocalPart());
                    throw CxfMessageUtil.orchestraToCxfFault(faultQName, faultDef, responseMessage);
                }
                DOMSource[] dOMSourceArray = CxfMessageUtil.orchestraToCxfMessage(responseMessage, operationStyle, operation.getOutput().getMessage());
                return dOMSourceArray;
            }
            DOMSource[] dOMSourceArray = null;
            return dOMSourceArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    private void processAttachments(Message inMessage) {
        List msgContent = (List)inMessage.getContent(List.class);
        for (DOMSource obj : msgContent) {
            Document doc = (Document)obj.getNode();
            NodeList includeNodes = doc.getElementsByTagNameNS("http://www.w3.org/2004/08/xop/include", "Include");
            block3: for (int i = 0; i < includeNodes.getLength(); ++i) {
                Element n = (Element)includeNodes.item(i);
                String attachmentId = XmlUtil.attribute((Element)n, (String)"href");
                if (attachmentId.startsWith("cid:")) {
                    attachmentId = attachmentId.substring(4);
                }
                for (Attachment attachment : inMessage.getAttachments()) {
                    if (!attachment.getId().equals(attachmentId)) continue;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int c;
                        InputStream inStream = attachment.getDataHandler().getInputStream();
                        byte[] buffer = new byte[1024];
                        while ((c = inStream.read(buffer)) != -1) {
                            baos.write(buffer, 0, c);
                        }
                    }
                    catch (IOException e) {
                        throw new OrchestraRuntimeException((Throwable)e);
                    }
                    n.getParentNode().replaceChild(doc.createTextNode(Base64Utility.encode((byte[])baos.toByteArray())), n);
                    continue block3;
                }
            }
        }
    }

    private static Operation getOperation(PortType portType, String operationName) {
        List operations = portType.getOperations();
        for (Operation operation : operations) {
            if (!operation.getName().equals(operationName)) continue;
            return operation;
        }
        return null;
    }
}

