/**
 * Copyright (C) 2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.cxf;

import java.util.List;

import org.apache.cxf.binding.soap.interceptor.RPCInInterceptor;
import org.apache.cxf.binding.soap.interceptor.RPCOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.BareOutInterceptor;
import org.apache.cxf.interceptor.Interceptor;


/**
 * @author Guillaume Porcher
 *
 */
public final class CxfUtils {
  private CxfUtils() { }

  @SuppressWarnings("unchecked")
  public static void setUpOrchestraInterceptors(final Endpoint endpoint) {
    // replace RPCInInterceptor interceptors
    final List<Interceptor> interceptors = endpoint.getBinding().getInInterceptors();
    for (final Interceptor i : interceptors) {
      if (i instanceof RPCInInterceptor) {
        interceptors.remove(i);
        interceptors.add(new BareInInterceptor());
        break;
      }
    }

    // replace RPCInInterceptor interceptors
    final List<Interceptor> outInterceptors = endpoint.getBinding().getOutInterceptors();
    for (final Interceptor i : outInterceptors) {
      if (i instanceof RPCOutInterceptor) {
        interceptors.remove(i);
        interceptors.add(new BareOutInterceptor());
        break;
      }
    }
  }
}
