/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.transport.CamelConduit;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.ow2.orchestra.cxf.CxfMessageUtil;
import org.ow2.orchestra.cxf.CxfPublisher;
import org.ow2.orchestra.cxf.CxfUtils;
import org.ow2.orchestra.cxf.OrchestraReflectionServiceFactoryBean;
import org.ow2.orchestra.exception.FaultWithMessageVariable;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.services.OperationKey;
import org.ow2.orchestra.services.itf.Invoker;
import org.ow2.orchestra.util.AddressingUtil;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.util.wsdl.WsdlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfInvoker
implements Invoker {
    private final CxfPublisher cxfPublisher = (CxfPublisher)((Object)Environment.getFromCurrent(CxfPublisher.class));

    public MessageVariable invoke(OperationKey operationKey, AddressingUtil.AddressingInfo addressingInfo, MessageVariable requestMessage, Set<Definition> wsdlDefinitions, Properties orchestraProperties) {
        Definition definition = addressingInfo.getWsdlDefinition();
        javax.wsdl.Service service = addressingInfo.getService();
        Port port = addressingInfo.getPort();
        if (port == null) {
            List services = WsdlUtil.getServicesOfPortType((QName)operationKey.getPortTypeQName(), wsdlDefinitions);
            addressingInfo.resolveServiceAndPort((Collection)services);
            port = addressingInfo.getPort();
            service = addressingInfo.getService();
            if (service == null) {
                service = (javax.wsdl.Service)services.get(0);
                for (Port p : service.getPorts().values()) {
                    if (!p.getBinding().getPortType().getQName().equals(operationKey.getPortTypeQName())) continue;
                    port = p;
                    break;
                }
            }
            for (Definition wsdlDefinition : wsdlDefinitions) {
                if (!service.equals(wsdlDefinition.getService(service.getQName()))) continue;
                definition = wsdlDefinition;
                break;
            }
        }
        if (service == null || definition == null || port == null) {
            throw new OrchestraRuntimeException("Can't find any supported service!");
        }
        Client client = this.createCxfClient(operationKey, addressingInfo, definition, service, port);
        BindingOperationInfo boi = client.getEndpoint().getEndpointInfo().getBinding().getOperation(new QName(operationKey.getPortTypeQName().getNamespaceURI(), operationKey.getOperationName()));
        OperationInfo operationInfo = boi.getOperationInfo();
        SoapBindingInfo bindingInfo = (SoapBindingInfo)boi.getBinding();
        String operationStyle = bindingInfo.getStyle(operationInfo);
        if (operationStyle == null) {
            operationStyle = bindingInfo.getStyle();
        }
        Operation operation = port.getBinding().getPortType().getOperation(operationKey.getOperationName(), null, null);
        try {
            DOMSource[] outMessage = CxfMessageUtil.orchestraToCxfMessage(requestMessage, operationStyle, operation.getInput().getMessage());
            Object[] res = client.invoke(operationKey.getOperationName(), (Object[])outMessage);
            if (operation.getOutput() != null) {
                DOMSource[] domRes = new DOMSource[res.length];
                for (int i = 0; i < res.length; ++i) {
                    domRes[i] = (DOMSource)res[i];
                }
                return CxfMessageUtil.cxfToOrchestraMessage(domRes, operationStyle, operation.getOutput().getMessage());
            }
            return null;
        }
        catch (SoapFault s) {
            Fault fault;
            QName faultName = s.getFaultCode();
            MessageVariable faultMessage = null;
            if (operationKey.getPortTypeQName().getNamespaceURI().equals(faultName.getNamespaceURI()) && (fault = operation.getFault(faultName.getLocalPart())) != null && s.hasDetails()) {
                Element detailEntry = s.getDetail();
                faultMessage = BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement((Collection)fault.getMessage().getOrderedParts(null), (Element)XmlUtil.element((Element)detailEntry));
            }
            throw new FaultWithMessageVariable(faultName, faultMessage);
        }
        catch (Exception e) {
            if (e instanceof OrchestraRuntimeException) {
                throw (OrchestraRuntimeException)e;
            }
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    private Client createCxfClient(OperationKey operationKey, AddressingUtil.AddressingInfo addressingInfo, Definition definition, javax.wsdl.Service service, Port port) {
        QName endpointQName = new QName(service.getQName().getNamespaceURI(), port.getName());
        WSDLServiceFactory wsdlServiceFactory = new WSDLServiceFactory(this.cxfPublisher.getCxfBus(), definition, service.getQName());
        wsdlServiceFactory.setEndpointName(endpointQName);
        Service cxfService = wsdlServiceFactory.create();
        for (OperationInfo opInfo : cxfService.getEndpointInfo(endpointQName).getInterface().getOperations()) {
            opInfo.setUnwrappedOperation(null);
        }
        OrchestraReflectionServiceFactoryBean rsfb = new OrchestraReflectionServiceFactoryBean(operationKey.getPortTypeQName(), cxfService);
        rsfb.setServiceName(service.getQName());
        rsfb.setEndpointName(endpointQName);
        ClientFactoryBean cliBean = new ClientFactoryBean((ReflectionServiceFactoryBean)rsfb);
        cliBean.setAddress(addressingInfo.getAddress());
        Client client = cliBean.create();
        if (client.getConduit() instanceof CamelConduit && this.cxfPublisher != null) {
            CamelContext camelContext = this.cxfPublisher.getCamelContext(operationKey.getProcessQName());
            CamelConduit camelConduit = (CamelConduit)client.getConduit();
            if (camelContext != null) {
                camelConduit.setCamelContext(camelContext);
            }
        }
        CxfUtils.setUpOrchestraInterceptors(client.getEndpoint());
        return client;
    }
}

