/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.ow2.orchestra.util.BpelSOAPUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class CxfMessageUtil {
    private CxfMessageUtil() {
    }

    public static MessageVariable cxfToOrchestraMessage(DOMSource[] cxfMessage, Object operationStyle, Message wsdlMessage) {
        ArrayList<Element> bodies = new ArrayList<Element>();
        for (DOMSource obj : cxfMessage) {
            Document doc = (Document)obj.getNode();
            bodies.add(doc.getDocumentElement());
        }
        MessageVariable incomingMessage = null;
        incomingMessage = operationStyle.equals("document") ? BpelSOAPUtil.buildMessageFromDocumentSOAPBodyElement((Collection)wsdlMessage.getOrderedParts(null), (Element)((Element)bodies.get(0))) : BpelSOAPUtil.buildMessageFromRpcSOAPBodyElement((Collection)wsdlMessage.getOrderedParts(null), (Element)((Element)bodies.get(0)));
        return incomingMessage;
    }

    public static DOMSource[] orchestraToCxfMessage(MessageVariable orchestraMessage, Object operationStyle, Message wsdlMessage) {
        int i;
        Element[] elementsReturned;
        if (operationStyle.equals("document")) {
            List parts = wsdlMessage.getOrderedParts(null);
            elementsReturned = new Element[parts.size()];
            i = 0;
            for (Part part : parts) {
                elementsReturned[i] = orchestraMessage.getPartValue(part.getName());
                ++i;
            }
        } else {
            Document rpcDocument = BpelSOAPUtil.buildRpcDocument((MessageVariable)orchestraMessage, (String)"temp");
            List rpcElements = XmlUtil.elements((Element)rpcDocument.getDocumentElement());
            elementsReturned = rpcElements.toArray(new Element[rpcElements.size()]);
        }
        DOMSource[] result = new DOMSource[elementsReturned.length];
        for (i = 0; i < elementsReturned.length; ++i) {
            result[i] = new DOMSource(elementsReturned[i]);
        }
        return result;
    }

    public static org.apache.cxf.interceptor.Fault orchestraToCxfFault(QName faultQName, Fault faultDef, MessageVariable orchestraFaultMessage) {
        SoapFault fault = new SoapFault("cxf fault", faultQName);
        Element detail = fault.getOrCreateDetail();
        if (faultDef != null) {
            Message faultMessage = faultDef.getMessage();
            List parts = faultMessage.getOrderedParts(null);
            for (Part part : parts) {
                Node importedNode = detail.getOwnerDocument().importNode(orchestraFaultMessage.getPartValue(part.getName()), true);
                detail.appendChild(importedNode);
            }
        } else if (orchestraFaultMessage.getParts() != null && orchestraFaultMessage.getParts().size() == 1) {
            Node importedNode = detail.getOwnerDocument().importNode((Node)orchestraFaultMessage.getParts().values().iterator().next(), true);
            detail.appendChild(importedNode);
        }
        return fault;
    }
}

