/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.OperationType;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Fault;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.transport.CamelDestination;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.ow2.orchestra.cxf.CxfPublisher;
import org.ow2.orchestra.cxf.CxfUtils;
import org.ow2.orchestra.cxf.CxfWSImpl;
import org.ow2.orchestra.cxf.OrchestraReflectionServiceFactoryBean;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.services.commands.CommandService;
import org.ow2.orchestra.ws.WSDeployer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CxfDeployer
extends WSDeployer {
    private final CxfPublisher cxfPublisher;

    public CxfDeployer(BpelProcess bpelProcess, CxfPublisher cxfPublisher) {
        super(bpelProcess);
        this.cxfPublisher = cxfPublisher;
    }

    protected String checkOperationStyle(String operationStyle) {
        if (operationStyle == null) {
            return "Style attribute of this operation must be specified";
        }
        if (!operationStyle.equals("document") && !operationStyle.equals("rpc")) {
            return "Style attribute of this operation must be : document or rpc";
        }
        return null;
    }

    protected String checkOperationType(OperationType operationType) {
        if (!operationType.equals(OperationType.REQUEST_RESPONSE) && !operationType.equals(OperationType.ONE_WAY)) {
            return "Operation type : " + operationType + " is not supported. Please use one of : " + OperationType.ONE_WAY + "/" + OperationType.REQUEST_RESPONSE;
        }
        return null;
    }

    protected String checkSoapVersion(ExtensibilityElement soapBinding) {
        if (!(soapBinding instanceof SOAPBinding) && !(soapBinding instanceof SOAP12Binding)) {
            return "Supported Soap Version are http://schemas.xmlsoap.org/wsdl/soap//http://schemas.xmlsoap.org/wsdl/soap12/";
        }
        return null;
    }

    protected String checkTransport(ExtensibilityElement soapBinding) {
        String transportUri = "";
        if (soapBinding instanceof SOAPBinding) {
            transportUri = ((SOAPBinding)soapBinding).getTransportURI();
        } else if (soapBinding instanceof SOAP12Binding) {
            transportUri = ((SOAP12Binding)soapBinding).getTransportURI();
        }
        if ("http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
            return null;
        }
        if ("http://cxf.apache.org/transports/camel".endsWith(transportUri)) {
            return null;
        }
        return "Transport URI : " + transportUri + " is not supported. Please use " + "http://schemas.xmlsoap.org/soap/http" + " or " + "http://cxf.apache.org/transports/camel";
    }

    protected String checkUse(ExtensibilityElement element) {
        String use = "";
        if (element instanceof SOAPBody) {
            use = ((SOAPBody)element).getUse();
        } else if (element instanceof SOAP12Body) {
            use = ((SOAP12Body)element).getUse();
        } else if (element instanceof SOAPFault) {
            use = ((SOAPFault)element).getUse();
        } else if (element instanceof SOAP12Fault) {
            use = ((SOAP12Fault)element).getUse();
        }
        if (!"literal".equals(use)) {
            return "Use : " + use + " is not supported. Please use " + "literal";
        }
        return null;
    }

    protected String checkSoapBody(ExtensibilityElement soapBody) {
        List parts = null;
        if (soapBody instanceof SOAPBody) {
            parts = ((SOAPBody)soapBody).getParts();
        } else if (soapBody instanceof SOAP12Body) {
            parts = ((SOAP12Body)soapBody).getParts();
        }
        if (parts != null) {
            return "SoapBody is using parts attribute which is not currently supported.";
        }
        return null;
    }

    protected String checkSoapFault(ExtensibilityElement soapFault) {
        String name = null;
        if (soapFault instanceof SOAPFault) {
            name = ((SOAPFault)soapFault).getName();
        } else if (soapFault instanceof SOAP12Fault) {
            name = ((SOAP12Fault)soapFault).getName();
        }
        if (name == null) {
            return "SoapFault is not specifying fault name which is not currently supported.";
        }
        return null;
    }

    protected void deployServices(List<javax.wsdl.Service> services) {
        for (javax.wsdl.Service service : services) {
            QName serviceQName = service.getQName();
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                QName endpointQName = new QName(serviceQName.getNamespaceURI(), port.getName());
                ServerFactoryBean svrBean = new ServerFactoryBean();
                svrBean.setBus(this.cxfPublisher.getCxfBus());
                String endpointURL = this.getAddressFromPort(port);
                if (endpointURL != null) {
                    svrBean.setAddress(endpointURL);
                } else {
                    svrBean.setAddress("/" + port.getName());
                }
                svrBean.setServiceName(serviceQName);
                Definition wsdlDefinition = this.bpelProcess.getWsdlInfos().extractServiceWsdlDefinition(service);
                WSDLServiceFactory wsdlServiceFactory = new WSDLServiceFactory(this.cxfPublisher.getCxfBus(), wsdlDefinition, serviceQName);
                wsdlServiceFactory.setEndpointName(endpointQName);
                Service cxfService = wsdlServiceFactory.create();
                EndpointInfo endpointInfo = cxfService.getEndpointInfo(endpointQName);
                for (OperationInfo opInfo : endpointInfo.getInterface().getOperations()) {
                    opInfo.setUnwrappedOperation(null);
                }
                endpointInfo.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, (Object)Boolean.TRUE);
                QName portTypeQname = port.getBinding().getPortType().getQName();
                OrchestraReflectionServiceFactoryBean rsfb = new OrchestraReflectionServiceFactoryBean(portTypeQname, cxfService);
                rsfb.setServiceName(serviceQName);
                rsfb.setEndpointName(endpointQName);
                HashMap<String, Boolean> locks = new HashMap<String, Boolean>();
                HashMap isOneWay = new HashMap();
                this.getLocksAndOneWays(port, locks, isOneWay);
                rsfb.setInvoker(new CxfWSImpl(port.getBinding().getPortType(), this.bpelProcess.getQName(), Environment.getCurrent().getClassLoader(), locks, (CommandService)Environment.getFromCurrent(CommandService.class)));
                svrBean.setServiceFactory((ReflectionServiceFactoryBean)rsfb);
                svrBean.setStart(false);
                Server server = svrBean.create();
                if (server.getDestination() instanceof CamelDestination) {
                    CamelDestination camelDestination = (CamelDestination)server.getDestination();
                    CamelContext camelContext = this.cxfPublisher.getCamelContext(this.bpelProcess.getQName());
                    if (camelContext != null) {
                        camelDestination.setCamelContext(camelContext);
                    }
                }
                CxfUtils.setUpOrchestraInterceptors(server.getEndpoint());
                if (endpointURL == null || !endpointURL.startsWith(this.expectedAddressPrefix) || this.cxfPublisher.addProcessEndpoint(endpointURL, this.bpelProcess.getQName(), port, this.bpelProcess.getUUID(), locks, isOneWay)) {
                    server.start();
                }
                if (endpointURL == null) continue;
                List extensibilityList = port.getExtensibilityElements();
                for (ExtensibilityElement obj : extensibilityList) {
                    if (obj instanceof SOAPAddress) {
                        ((SOAPAddress)obj).setLocationURI(endpointURL);
                        continue;
                    }
                    if (!(obj instanceof SOAP12Address)) continue;
                    ((SOAP12Address)obj).setLocationURI(endpointURL);
                }
            }
        }
    }

    protected boolean isAddressSupported(String address) {
        return address.startsWith("camel:") || super.isAddressSupported(address);
    }

    protected void undeployServices(List<javax.wsdl.Service> services) {
        ServerRegistry serverRegistry = (ServerRegistry)this.cxfPublisher.getCxfBus().getExtension(ServerRegistry.class);
        for (javax.wsdl.Service service : services) {
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                String endpointURL = this.getAddressFromPort(port);
                QName endpointQName = new QName(service.getQName().getNamespaceURI(), port.getName());
                List servers = serverRegistry.getServers();
                if (servers == null) continue;
                for (Server server : new ArrayList(servers)) {
                    if (!server.getEndpoint().getService().getName().equals(service.getQName()) || !server.getEndpoint().getEndpointInfo().getName().equals(endpointQName)) continue;
                    String serverEndpointURL = (this.expectedAddressPrefix.endsWith("/") ? this.expectedAddressPrefix.substring(0, this.expectedAddressPrefix.lastIndexOf(47)) : this.expectedAddressPrefix) + server.getEndpoint().getEndpointInfo().getAddress();
                    if (endpointURL.startsWith(this.expectedAddressPrefix) && (!endpointURL.equals(serverEndpointURL) || !this.cxfPublisher.removeProcessEndpoint(endpointURL, this.bpelProcess.getUUID()))) continue;
                    server.stop();
                }
            }
        }
    }

    protected void checkWSEngineIsAvailable() {
    }
}

