package org.ow2.orchestra.cxf;

import javax.xml.namespace.QName;

import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;

/**
 *
 * @author Guillaume Porcher
 *
 */
public class OrchestraReflectionServiceFactoryBean extends ReflectionServiceFactoryBean {
  private final QName portTypeQName;
  private final org.apache.cxf.service.Service cxfService;

  /**
   * @param port
   * @param cxfService
   */
  public OrchestraReflectionServiceFactoryBean(final QName portTypeQName, final org.apache.cxf.service.Service cxfService) {
    this.portTypeQName = portTypeQName;
    this.cxfService = cxfService;
    this.serviceClass = Object.class;
    this.setDataBinding(new SourceDataBinding());

  }
  @Override
  public QName getInterfaceName() {
    return this.portTypeQName;
  }

  @Override
  protected void initializeServiceModel() {
    this.setService(this.cxfService);
  }

  @Override
  public void setServiceClass(final Class< ? > serviceClass) {
    if (serviceClass != null) {
      super.setServiceClass(serviceClass);
    }
  }

}
