/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.camel.component.cxf.transport.CamelTransportFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.ow2.orchestra.cxf.CxfPublisher;
import org.ow2.orchestra.cxf.OrchestraCxfServletTransportFactory;

public class OrchestraCxfServlet
extends CXFServlet {
    private static final long serialVersionUID = 2528286722832028480L;
    private final CxfPublisher cxfPublisher;
    private final String context;

    public OrchestraCxfServlet(CxfPublisher cxfPublisher, String context) {
        this.cxfPublisher = cxfPublisher;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBus(ServletConfig servletConfig) throws ServletException {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CXFServlet.class.getClassLoader());
        try {
            super.loadBus(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        CamelTransportFactory camelTransportFactory = new CamelTransportFactory();
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.bus.getExtension(ConduitInitiatorManager.class);
        cim.registerConduitInitiator("http://cxf.apache.org/transports/camel", (ConduitInitiator)camelTransportFactory);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/camel", (DestinationFactory)camelTransportFactory);
        InstrumentationManager instrumentationManager = (InstrumentationManager)this.bus.getExtension(InstrumentationManager.class);
        if (instrumentationManager != null && instrumentationManager instanceof InstrumentationManagerImpl) {
            InstrumentationManagerImpl instrumentationManagerImpl = (InstrumentationManagerImpl)instrumentationManager;
            instrumentationManagerImpl.setUsePlatformMBeanServer(Boolean.valueOf(true));
            instrumentationManagerImpl.setBus(this.bus);
            instrumentationManagerImpl.setCreateMBServerConnectorFactory(false);
            instrumentationManagerImpl.init();
        }
        this.cxfPublisher.setCxfBus(this.bus);
    }

    protected DestinationFactory createServletTransportFactory() {
        if (this.servletTransportFactory == null) {
            this.servletTransportFactory = new OrchestraCxfServletTransportFactory(this.bus, this.context);
        }
        return this.servletTransportFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bus.class.getClassLoader());
            super.invoke(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

