package org.ow2.orchestra.cxf;

import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.services.handlers.impl.ArchiveFinishedInstanceHandler;
import org.ow2.orchestra.services.handlers.impl.ArchiveUndeployedProcessHandler;
import org.ow2.orchestra.services.handlers.impl.DeleteFinishedInstanceHandler;

import java.io.IOException;

/**
 * generates a default environment for running orchestra with cxf.
 *
 * @author Guillaume Porcher
 */
public class CxfEnvXmlGenerator extends DefaultEnvXMLGenerator {


  public CxfEnvXmlGenerator(final String hibernateRelativePath, final InstallationType installationType) {
    super(hibernateRelativePath, installationType);
    this.setPublisherType(CxfPublisher.class);
    this.setInvokerType(CxfInvoker.class);
    if (installationType.hasJournal() && installationType.hasHistory()) {
      this.setFinishedInstanceHandlerType(DeleteFinishedInstanceHandler.class, ArchiveFinishedInstanceHandler.class);
      this.setUndeployedProcessHandlerType(ArchiveUndeployedProcessHandler.class);
    } else {
      this.setFinishedInstanceHandlerType(DeleteFinishedInstanceHandler.class);
    }
  }

  /**
   * Prints the default environment on standard output.
   *
   * @param args
   * @throws IOException
   */
  public static void main(final String[] args) throws IOException {
    String[] newArgs = new String[args.length+1];
    newArgs[0] = CxfEnvXmlGenerator.class.getName();
    for (int i = 0; i < args.length; i++) {
      newArgs[i + 1] = args[i];
    }
    DefaultEnvXMLGenerator.main(newArgs);
  }
}
