/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.cxf;

import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.transport.CamelConduit;
import org.apache.camel.component.cxf.transport.CamelTransportFactory;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

import javax.xml.namespace.QName;
import java.io.IOException;

/**
 * @author Guillaume Porcher
 */
public class OrchestraCamelTransportFactory extends CamelTransportFactory {

  private final CxfPublisher cxfPublisher;

  public OrchestraCamelTransportFactory(final CxfPublisher cxfPublisher) {
    this.cxfPublisher = cxfPublisher;
  }

  @Override
  public Conduit getConduit(EndpointInfo endpointInfo, EndpointReferenceType target) throws IOException {
    QName processQName = (QName) endpointInfo.getProperty("processQName");

    final CamelContext camelContext = this.cxfPublisher.getCamelContext(processQName);

    return new CamelConduit(camelContext, this.getBus(), endpointInfo, target, this.getHeaderFilterStrategy());
  }
}
