/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.jmx.InstrumentationManagerImpl;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.ow2.orchestra.cxf.CxfPublisher;
import org.ow2.orchestra.cxf.OrchestraCamelTransportFactory;
import org.ow2.orchestra.cxf.OrchestraCxfServletTransportFactory;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.rest.JaxRSInstanceManagementAPIImpl;
import org.ow2.orchestra.rest.JaxRSManagementAPIImpl;
import org.ow2.orchestra.rest.JaxRSQueryDefinitionAPIImpl;
import org.ow2.orchestra.rest.JaxRSQueryRuntimeAPIImpl;
import org.ow2.orchestra.util.JAXBUtils;

public class OrchestraCxfServlet
extends CXFServlet {
    private static final long serialVersionUID = 2528286722832028480L;
    private final CxfPublisher cxfPublisher;
    private final String context;
    private final EnvironmentFactory environmentFactory;

    public OrchestraCxfServlet(CxfPublisher cxfPublisher, String context, EnvironmentFactory environmentFactory) {
        this.cxfPublisher = cxfPublisher;
        this.context = context;
        this.environmentFactory = environmentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBus(ServletConfig servletConfig) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CXFServlet.class.getClassLoader());
        try {
            super.loadBus(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        OrchestraCamelTransportFactory camelTransportFactory = new OrchestraCamelTransportFactory(this.cxfPublisher);
        ConduitInitiatorManager cim = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
        cim.registerConduitInitiator("http://cxf.apache.org/transports/camel", (ConduitInitiator)camelTransportFactory);
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.getBus().getExtension(DestinationFactoryManager.class);
        dfm.registerDestinationFactory("http://cxf.apache.org/transports/camel", (DestinationFactory)camelTransportFactory);
        InstrumentationManager instrumentationManager = (InstrumentationManager)this.getBus().getExtension(InstrumentationManager.class);
        if (instrumentationManager != null && instrumentationManager instanceof InstrumentationManagerImpl) {
            InstrumentationManagerImpl instrumentationManagerImpl = (InstrumentationManagerImpl)instrumentationManager;
            instrumentationManagerImpl.setUsePlatformMBeanServer(Boolean.valueOf(true));
            instrumentationManagerImpl.setEnabled(true);
            instrumentationManagerImpl.setBus(this.getBus());
            instrumentationManagerImpl.setCreateMBServerConnectorFactory(false);
            instrumentationManagerImpl.init();
        }
        new OrchestraCxfServletTransportFactory(this.getBus(), this.context);
        this.registerRESTApis();
        this.cxfPublisher.setCxfBus(this.getBus());
    }

    private void registerRESTApis() {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setServiceBeanObjects(new Object[]{new JaxRSManagementAPIImpl(this.environmentFactory), new JaxRSInstanceManagementAPIImpl(this.environmentFactory), new JaxRSQueryDefinitionAPIImpl(this.environmentFactory), new JaxRSQueryRuntimeAPIImpl(this.environmentFactory)});
        sf.setAddress("/apis");
        JAXBElementProvider provider = new JAXBElementProvider();
        provider.setCollectionWrapperName("collection");
        provider.setSingleJaxbContext(true);
        provider.setExtraClass(JAXBUtils.JAXB_CLASSES);
        sf.setProvider((Object)provider);
        sf.setBus(this.getBus());
        sf.setStart(false);
        Server s = sf.create();
        s.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Bus.class.getClassLoader());
            super.invoke(request, response);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

