/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrchestraCxfServiceContractResolver {
    private final Bus bus;
    private DestinationRegistry destinationRegistry;

    public OrchestraCxfServiceContractResolver(Bus bus) {
        this.bus = bus;
        this.destinationRegistry = OrchestraCxfServiceContractResolver.getDestinationRegistryFromBus(this.bus);
    }

    public AbstractDestination getDestinationForPortType(String portTypeName) {
        if (this.destinationRegistry != null) {
            AbstractDestination[] soapEndpoints;
            AbstractDestination[] destinations = this.destinationRegistry.getSortedDestinations();
            List privateEndpoints = this.bus != null ? (List)this.bus.getProperty("org.apache.cxf.private.endpoints") : new ArrayList();
            for (AbstractDestination soapEndpoint : soapEndpoints = this.getSOAPEndpoints(destinations, privateEndpoints)) {
                if (!portTypeName.equals(soapEndpoint.getEndpointInfo().getInterface().getName().getLocalPart())) continue;
                return soapEndpoint;
            }
        }
        return null;
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException busException) {
            // empty catch block
        }
        return null;
    }

    private AbstractDestination[] getSOAPEndpoints(AbstractDestination[] destinations, List<String> privateEndpoints) {
        ArrayList<AbstractDestination> soapEndpoints = new ArrayList<AbstractDestination>();
        for (AbstractDestination sd : destinations) {
            if (null == sd.getEndpointInfo().getName() || null == sd.getEndpointInfo().getInterface() || this.isPrivate(sd.getEndpointInfo(), privateEndpoints)) continue;
            soapEndpoints.add(sd);
        }
        return soapEndpoints.toArray(new AbstractDestination[0]);
    }

    private boolean isPrivate(EndpointInfo ei, List<String> privateEndpoints) {
        if (privateEndpoints != null) {
            for (String s : privateEndpoints) {
                if (!ei.getAddress().endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }
}

