/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.cxf;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.cxf.Bus;
import org.ops4j.pax.swissbox.tinybundles.core.BuildableBundle;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundle;
import org.ops4j.pax.swissbox.tinybundles.core.TinyBundles;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.ow2.orchestra.cxf.CxfDeployer;
import org.ow2.orchestra.cxf.OrchestraCxfServlet;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.env.Environment;
import org.ow2.orchestra.env.EnvironmentFactory;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.services.impl.PublisherImpl;
import org.ow2.orchestra.services.itf.HttpPublisher;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.ProcessResourcesRepository;
import org.ow2.orchestra.util.XmlUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextEvent;
import org.springframework.osgi.context.event.OsgiBundleApplicationContextListener;
import org.springframework.osgi.context.event.OsgiBundleContextFailedEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CxfPublisher
extends PublisherImpl
implements HttpPublisher {
    private static final Logger LOG = Logger.getLogger(CxfPublisher.class.getName());
    private final Map<QName, SpringCamelContext> camelContexts = new HashMap<QName, SpringCamelContext>();
    private final Map<QName, Bundle> bundles = new HashMap<QName, Bundle>();
    private Bus cxfBus;
    private long timeout = 180000L;

    public BundleContext getBundleContext() {
        return (BundleContext)Environment.getFromCurrent((String)"orchestra.bundle.context");
    }

    private void createCamelContext(BpelProcess bpelProcess) {
        byte[] camelContextBytes = (byte[])bpelProcess.getResourcesRepository().getResources().get("camel-context.xml");
        if (camelContextBytes != null) {
            try {
                InputStream processBundleStream = this.createBundle(bpelProcess);
                ApplicationContext applicationContext = this.deployBundle(processBundleStream, bpelProcess);
                SpringCamelContext camelContext = SpringCamelContext.springCamelContext((ApplicationContext)applicationContext);
                this.camelContexts.put(bpelProcess.getQName(), camelContext);
            }
            catch (Exception e) {
                throw new OrchestraRuntimeException("Error while creating camel context", (Throwable)e);
            }
        }
    }

    private void deleteCamelContext(BpelProcess bpelProcess) {
        Bundle bundle = this.bundles.remove(bpelProcess.getQName());
        this.camelContexts.remove(bpelProcess.getQName());
        if (bundle != null) {
            try {
                bundle.uninstall();
            }
            catch (BundleException e) {
                throw new OrchestraRuntimeException((Throwable)e);
            }
        }
    }

    public CamelContext getCamelContext(QName processQName) {
        return (CamelContext)this.camelContexts.get(processQName);
    }

    public void publishServices(BpelProcess bpelProcess, Environment environment) {
        super.publishServices(bpelProcess, environment);
        this.doDeploy(bpelProcess);
    }

    public InputStream createBundle(BpelProcess bpelProcess) {
        ProcessResourcesRepository processResourcesRepository = bpelProcess.getResourcesRepository();
        TinyBundle bundle = TinyBundles.newBundle();
        for (Map.Entry entry : processResourcesRepository.getResources().entrySet()) {
            if (!((String)entry.getKey()).equals("camel-context.xml")) {
                bundle.add((String)entry.getKey(), (InputStream)new ByteArrayInputStream((byte[])entry.getValue()));
                continue;
            }
            bundle.add("META-INF/spring/camel-context.xml", (InputStream)new ByteArrayInputStream(this.instrumentContextDefinition((byte[])entry.getValue(), bpelProcess.getUUID())));
        }
        BuildableBundle buildableBundle = bundle.prepare(TinyBundles.withBnd().set("Bundle-SymbolicName", "Orchestra process: " + bpelProcess.getUUID()).set("DynamicImport-Package", "*").set("Spring-Context", "META-INF/spring/camel-context.xml;create-asynchronously:=false").set("-plugin", "aQute.lib.spring.SpringComponent"));
        InputStream bundleStream = buildableBundle.build();
        return bundleStream;
    }

    private byte[] instrumentContextDefinition(byte[] value, ProcessDefinitionUUID processDefinitionUUID) {
        Document doc = XmlUtil.getDocumentFromString((String)new String(value));
        NodeList nl = doc.getElementsByTagNameNS("http://camel.apache.org/schema/spring", "camelContext");
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                el.setAttribute("autoStartup", "true");
                String oldId = XmlUtil.attribute((Element)el, (String)"id");
                String newId = "orchestra-" + processDefinitionUUID + (i == 0 ? "" : "-" + i);
                if (oldId != null) {
                    Element alias = doc.createElementNS("http://www.springframework.org/schema/beans", "alias");
                    alias.setAttribute("name", newId);
                    alias.setAttribute("alias", oldId);
                    doc.getDocumentElement().appendChild(alias);
                    Misc.fastDynamicLog((Logger)LOG, (Level)Level.WARNING, (String)"Replacing camel context id '%s' by '%s'. Add an alias definition for reference to old id.", (Object[])new Object[]{oldId, newId});
                }
                el.setAttribute("id", newId);
            }
        }
        return XmlUtil.toString((Node)doc).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationContext deployBundle(InputStream bundleStream, BpelProcess bpelProcess) {
        try {
            Bundle installedBundle = this.getBundleContext().installBundle("OrchestraProcess" + bpelProcess.getUUID(), bundleStream);
            this.bundles.put(bpelProcess.getQName(), installedBundle);
            BpelBundleApplicationContextListener bundleResultListener = new BpelBundleApplicationContextListener(installedBundle);
            ServiceRegistration sReg = this.getBundleContext().registerService(OsgiBundleApplicationContextListener.class.getName(), (Object)bundleResultListener, null);
            try {
                installedBundle.start();
            }
            finally {
                sReg.unregister();
            }
            if (bundleResultListener.getFailure() != null) {
                if (bundleResultListener.getFailure() instanceof RuntimeException) {
                    throw (RuntimeException)bundleResultListener.getFailure();
                }
                throw new OrchestraRuntimeException(bundleResultListener.getFailure());
            }
            return bundleResultListener.getApplicationContext();
        }
        catch (BundleException e) {
            throw new OrchestraRuntimeException((Throwable)e);
        }
    }

    public void unpublishServices(BpelProcess bpelProcess, Environment environment) {
        CxfDeployer cxfDeployer = new CxfDeployer(bpelProcess, this);
        List services = this.getServices(bpelProcess);
        if (services != null) {
            cxfDeployer.undeploy(services);
        }
        this.deleteCamelContext(bpelProcess);
        super.unpublishServices(bpelProcess, environment);
    }

    protected void doDeploy(BpelProcess bpelProcess) {
        try {
            this.createCamelContext(bpelProcess);
            CxfDeployer cxfDeployer = new CxfDeployer(bpelProcess, this);
            List services = this.getServices(bpelProcess);
            if (services != null) {
                cxfDeployer.deploy(services);
            }
        }
        catch (RuntimeException e) {
            this.deleteCamelContext(bpelProcess);
            throw e;
        }
    }

    public Servlet getPublisherServlet(EnvironmentFactory environmentFactory, Properties orchestraProperties) {
        String context = "http://" + orchestraProperties.getProperty("orchestra.servlet.host") + ":" + orchestraProperties.getProperty("orchestra.servlet.port") + "/" + orchestraProperties.getProperty("orchestra.servlet.path");
        return new OrchestraCxfServlet(this, context, environmentFactory);
    }

    public Bus getCxfBus() {
        return this.cxfBus;
    }

    public void setCxfBus(Bus cxfBus) {
        this.cxfBus = cxfBus;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    private static final class BpelBundleApplicationContextListener
    implements OsgiBundleApplicationContextListener {
        private final Bundle installedBundle;
        private Throwable failure;
        private ApplicationContext applicationContext;

        private BpelBundleApplicationContextListener(Bundle installedBundle) {
            this.installedBundle = installedBundle;
        }

        public void onOsgiApplicationEvent(OsgiBundleApplicationContextEvent event) {
            if (event.getBundle().equals(this.installedBundle)) {
                if (event instanceof OsgiBundleContextFailedEvent) {
                    this.failure = ((OsgiBundleContextFailedEvent)event).getFailureCause();
                }
                this.applicationContext = event.getApplicationContext();
            }
        }

        public Throwable getFailure() {
            return this.failure;
        }

        public ApplicationContext getApplicationContext() {
            return this.applicationContext;
        }
    }
}

