/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */
package org.ow2.orchestra.extensions.logging;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.ow2.orchestra.definition.activity.InterfaceActivity;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;

/**
 * @author Guillaume Porcher
 */
public class LogActivity implements InterfaceActivity {

  protected String loggerName;
  protected String levelName;
  protected Expression expression;

  protected void setLoggerName(String loggerName) {
    this.loggerName = loggerName;
  }

  protected void setLevelName(String levelName) {
    this.levelName = levelName;
  }

  protected void setExpression(Expression expression) {
    this.expression = expression;
  }

  public void execute(BpelExecution execution) {
    Logger logger = Logger.getLogger(this.loggerName);
    Level level = Level.parse(this.levelName);
    if (logger.isLoggable(level)) {
      From from = new From();
      from.setExpression(this.expression);
      from.setVariant(Variant.EXPR);
      Object value = from.getValue(execution);
      logger.log(level, stringValueOf(value));
    }
  }

  private String stringValueOf(Object value) {
    if (value instanceof String) {
      return (String) value;
    } else if (value instanceof Node) {
      return XmlUtil.toString((Node) value);
    } else {
      return String.valueOf(value);
    }
  }

  public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
    throw new OrchestraRuntimeException("Signal not supported.");
  }
}
