/*
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */
package org.ow2.orchestra.extensions.logging;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.InterfaceActivity;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.parsing.BpelParser;
import org.ow2.orchestra.parsing.binding.AbstractExtensionActivityBinding;
import org.ow2.orchestra.util.BpelUtil;
import org.ow2.orchestra.util.XmlUtil;
import org.ow2.orchestra.xml.Parse;
import org.ow2.orchestra.xml.Parser;
import org.w3c.dom.Element;

/**
 * @author Guillaume Porcher
 */
public class LogBinding extends AbstractExtensionActivityBinding {

  public LogBinding() {
    super("log", LoggingExtensionProviderImpl.LOGGING_EXTENSION, BpelParser.CATEGORY_EXTENSION_ACTIVITY);
  }

  public InterfaceActivity parse(Element element, Parse parse, Parser parser) {
    final BpelProcess bpelProcess = parse.findObject(BpelProcess.class);

    LogActivity logActivity = new LogActivity();
    logActivity.setLoggerName(XmlUtil.attribute(element, "logger"));
    logActivity.setLevelName(XmlUtil.attribute(element, "level"));
    Expression expression = new Expression();
    expression.setLanguage(bpelProcess.getExpressionLanguage());
    expression.setNamespaces(BpelUtil.getAllNameSpaces(element));
    expression.setText(XmlUtil.getContentText(element));
    logActivity.setExpression(expression);
    return logActivity;
  }
}
