/**
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.extensions.logging;


import java.util.ArrayList;
import java.util.List;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.definition.activity.ExtensionActivity;
import org.ow2.orchestra.extension.ExtensionProvider;
import org.ow2.orchestra.xml.Binding;
import org.ow2.orchestra.xml.Parse;
import org.w3c.dom.Element;


/**
 * @author: Guillaume Porcher
 */
public class LoggingExtensionProviderImpl implements ExtensionProvider {
  public static final String LOGGING_EXTENSION = "http://orchestra.ow2.org/extensions/logging";


  public LoggingExtensionProviderImpl() {
  }

  public String[] getSchemaResource() {
    String[] resource = new String[]{
            LoggingExtensionProviderImpl.class.getResource("orchestra-logging.xsd").toExternalForm()
    };
    return resource;
  }


  public List<Binding> getDefaultBindings() {
    List<Binding> bindings = new ArrayList<Binding>();
    bindings.add(new LogBinding());
    return bindings;
  }

  public void parseExtensionAttribute(Element element, Parse parse) {

  }

  public void parseExtensionElement(Element element, Parse parse) {
  }

  public boolean isSupported(String namespace) {
    return namespace.equals(LoggingExtensionProviderImpl.LOGGING_EXTENSION);
  }

  public void deployExternalModule(BpelProcess bpelProcess) {
    List<ExtensionActivity> extensionActivities = bpelProcess.getExtensionActivities();

  }

  public void unDeployExternalModule(BpelProcess bpelProcess) {
    List<ExtensionActivity> extensionActivities = bpelProcess.getExtensionActivities();
  }

}
