/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.extensions.logging.test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.env.DefaultEnvXMLGenerator;
import org.ow2.orchestra.extensions.logging.LoggingExtensionProviderImpl;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.EnvironmentTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class LoggingExtensionTest
extends BpelTestCase {
    public LoggingExtensionTest() {
        super("http://enterprise.netbeans.org/bpel/echo/echo_1", "echo");
    }

    public void testLoggingExtension() throws TimeoutException {
        Logger logger = Logger.getLogger("org.example.test");
        TestHandler testHandler = new TestHandler();
        testHandler.setLevel(Level.ALL);
        logger.addHandler(testHandler);
        logger.setLevel(Level.ALL);
        ProcessDefinition pd1 = this.deploy();
        String name = "Dupont";
        Assert.assertEquals((String)"Dupont", (String)this.executeProcess("Dupont"));
        this.undeploy();
        Assert.assertEquals((int)3, (int)testHandler.getRecords().size());
        Assert.assertEquals((Object)Level.FINEST, (Object)testHandler.getRecords().get(0).getLevel());
        Assert.assertEquals((Object)Level.INFO, (Object)testHandler.getRecords().get(1).getLevel());
        Assert.assertEquals((Object)Level.WARNING, (Object)testHandler.getRecords().get(2).getLevel());
        Assert.assertEquals((String)"Great extension !!!", (String)testHandler.getRecords().get(0).getMessage());
        Assert.assertEquals((String)"Dupont", (String)testHandler.getRecords().get(1).getMessage());
        Assert.assertEquals((String)"Hello Dupont !!", (String)testHandler.getRecords().get(2).getMessage());
    }

    private String executeProcess(String input) throws TimeoutException {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("inputType", BpelXmlUtil.createElementWithContent((String)input));
        QName portTypeQName = new QName("http://localhost/echo/echo", "portType1");
        String operationName = "operation1";
        BpelTestCase.CallResult cr = this.call(parts, portTypeQName, "operation1");
        MessageVariable result = cr.getMessageCarrier().getMessage(5000L);
        this.deleteInstance(cr);
        String resultString = result.getPartValue("resultType").getTextContent();
        return resultString;
    }

    public DefaultEnvXMLGenerator getEnvGenerator() {
        DefaultEnvXMLGenerator envGenerator = EnvironmentTestCase.getBpelTestEnvGenerator();
        envGenerator.addExtensionProviderType("<extensionProvider class='" + LoggingExtensionProviderImpl.class.getName() + "' />");
        envGenerator.addExtension("ext-logging.mappings.xml");
        return envGenerator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestHandler
    extends Handler {
        List<LogRecord> records = new ArrayList<LogRecord>();

        private TestHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        public List<LogRecord> getRecords() {
            return this.records;
        }
    }
}

