/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.extensions.logging;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.orchestra.definition.activity.InterfaceActivity;
import org.ow2.orchestra.definition.element.From;
import org.ow2.orchestra.facade.def.Variant;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.lang.Expression;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogActivity
implements InterfaceActivity {
    protected String loggerName;
    protected String levelName;
    protected Expression expression;

    protected void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    protected void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    protected void setExpression(Expression expression) {
        this.expression = expression;
    }

    public void execute(BpelExecution execution) {
        Level level;
        Logger logger = Logger.getLogger(this.loggerName);
        if (logger.isLoggable(level = Level.parse(this.levelName))) {
            From from = new From();
            from.setExpression(this.expression);
            from.setVariant(Variant.EXPR);
            Object value = from.getValue(execution);
            logger.log(level, this.stringValueOf(value));
        }
    }

    private String stringValueOf(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Node) {
            return XmlUtil.toString((Node)((Node)value));
        }
        return String.valueOf(value);
    }

    public void signal(BpelExecution execution, String signal, Map<String, Object> parameters) {
        throw new OrchestraRuntimeException("Signal not supported.");
    }
}

