package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class ClientOptions {

  static final String HELP_OPTION = "help";

  static final String HELP_SHORT_OPTION = "h";

  static final String DEPLOY_OPTION = "deploy";

  static final String DEPLOY_SHORT_OPTION = "d";

  static final String UNDEPLOY_OPTION = "undeploy";

  static final String UNDEPLOY_SHORT_OPTION = "u";

  static final String LIST_OPTION = "list";

  static final String LIST_INSTANCE_OPTION = "listInstance";

  static final String LIST_SHORT_OPTION = "l";

  static final String GET_OPTION = "get";

  static final String GET_PROCESS_OPTION = "getProcess";

  static final String GET_SHORT_OPTION = "g";

  static final String STATUS_OPTION = "status";

  static final String STATUS_SHORT_OPTION = "s";

  static final String INIT_OPTION = "initialize";

  static final String INIT_SHORT_OPTION = "init";

  static final String LAUNCH_OPTION = "call";

  static final String LAUNCH_SHORT_OPTION = "c";

  static final String BPEL_OPTION = "bpel";

  static final String BPEL_SHORT_OPTION = "b";

  static final String BAR_OPTION = "bar";

  static final String WSDL_OPTION = "wsdls";

  static final String WSDL_SHORT_OPTION = "w";

  static final String JMX_URL_OPTION = "jmxUrl";

  static final String JMX_URL_SHORT_OPTION = "ju";

  static final String JMX_OBJECT_OPTION = "jmxObject";

  static final String JMX_OBJECT_SHORT_OPTION = "jo";

  static final String PROCESS_QNAME_OPTION = "process";

  static final String PROCESS_QNAME_SHORT_OPTION = "p";

  static final String WS_ENDPOINT_OPTION = "endpoint";

  static final String WS_ENDPOINT_SHORT_OPTION = "ws";

  static final String SOAP_ACTION_OPTION = "soapAction";

  static final String SOAP_ACTION_SHORT_OPTION = "a";

  static final String SOAP_MSG_OPTION = "soapMessage";

  static final String SOAP_MSG_SHORT_OPTION = "m";

  private ClientOptions() {
  }

  protected static Options createHelpOptions() {
    Options options = new Options();

    // Create options
    Option help = new Option(HELP_SHORT_OPTION, HELP_OPTION, false,
        "print this message");
    options.addOption(help);
    help.setRequired(true);

    return options;
  }

  protected static Options createDeployOptions() {
    Options options = new Options();

    Option deploy = new Option(DEPLOY_SHORT_OPTION, DEPLOY_OPTION, false,
        "deploy the process");
    deploy.setRequired(true);

    Option bpelfile = new Option(BPEL_SHORT_OPTION, BPEL_OPTION, true,
        "use given bpel file");
    bpelfile.setArgName("file");
    bpelfile.setRequired(true);

    Option wsdlFiles = new Option(WSDL_SHORT_OPTION, WSDL_OPTION, true,
        "use given wsdl files");
    wsdlFiles.setArgName("file,file,...");
    wsdlFiles.setValueSeparator(' ');

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(bpelfile);
    options.addOption(wsdlFiles);
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    // Only one action at the same time
    options.addOption(deploy);

    return options;
  }

  protected static Options createDeployBarOptions() {
    Options options = new Options();

    Option deploy = new Option(DEPLOY_SHORT_OPTION, DEPLOY_OPTION, false,
        "deploy the process");
    deploy.setRequired(true);

    Option barfile = new Option(BAR_OPTION, true, "use given bar file");
    barfile.setArgName("file");
    barfile.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(barfile);
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    // Only one action at the same time
    options.addOption(deploy);

    return options;
  }

  protected static Options createUndeployOptions() {
    Options options = new Options();
    Option undeploy = new Option(UNDEPLOY_SHORT_OPTION, UNDEPLOY_OPTION, false,
        "undeploy the process");
    undeploy.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    Option processName = OptionBuilder.withLongOpt(PROCESS_QNAME_OPTION)
        .withArgName("name").hasArg().withDescription("name of the process")
        .create(PROCESS_QNAME_SHORT_OPTION);
    processName.setRequired(true);

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);
    options.addOption(processName);
    options.addOption(undeploy);

    return options;
  }

  protected static Options createGetProcessOptions() {
    Options options = new Options();
    Option getProcess = new Option(GET_PROCESS_OPTION, false,
        "get info for the process");
    getProcess.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    Option processName = OptionBuilder.withLongOpt(PROCESS_QNAME_OPTION)
        .withArgName("name").hasArg().withDescription("name of the process")
        .create(PROCESS_QNAME_SHORT_OPTION);
    processName.setRequired(true);

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);
    options.addOption(processName);
    options.addOption(getProcess);

    return options;
  }

  protected static Options createLaunchOptions() {
    Options options = new Options();

    Option launch = new Option(LAUNCH_SHORT_OPTION, LAUNCH_OPTION, false,
        "launch the process");
    launch.setRequired(true);

    Option endpoint = OptionBuilder.withLongOpt(WS_ENDPOINT_OPTION)
        .withArgName("url").hasArg().withDescription("WS endpoint").create(
            WS_ENDPOINT_SHORT_OPTION);

    Option soapAction = OptionBuilder.withLongOpt(SOAP_ACTION_OPTION)
        .withArgName("action").hasArg().withDescription("WS SOAP Action")
        .create(SOAP_ACTION_SHORT_OPTION);

    Option soapMessage = OptionBuilder.withLongOpt(SOAP_MSG_OPTION)
        .withArgName("message").hasArg().withDescription("WS SOAP Message")
        .create(SOAP_MSG_SHORT_OPTION);

    // Add options to the client
    options.addOption(endpoint);
    options.addOption(soapAction);
    options.addOption(soapMessage);

    options.addOption(launch);

    return options;
  }

  protected static Options createListOptions() {
    Options options = new Options();

    Option list = new Option(LIST_SHORT_OPTION, LIST_OPTION, false,
        "list deployed process");
    list.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createListInstanceOptions() {
    Options options = new Options();

    Option list = new Option(LIST_INSTANCE_OPTION, false,
        "list deployed instances");
    list.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createStatusOptions() {
    Options options = new Options();

    Option list = new Option(STATUS_SHORT_OPTION, STATUS_OPTION, false,
        "get Orchestra status");
    list.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createInitOptions() {
    Options options = new Options();

    Option list = new Option(INIT_SHORT_OPTION, INIT_OPTION, false,
        "initialize orchestra engine");
    list.setRequired(true);

    Option jmxServiceUrl = new Option(JMX_URL_SHORT_OPTION, JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    Option jmxObjectName = new Option(JMX_OBJECT_SHORT_OPTION,
        JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }
}
