/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;
import org.ow2.orchestra.parsing.BpelImportParser;
import org.ow2.orchestra.util.Misc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployAction
implements ClientAction {
    private Options options = ClientOptions.createDeployOptions();

    public static ProcessDefinition deploy(URL bpelURL, List<URL> wsdls, String jmxServiceUrl, String jmxObjectName) {
        ProcessDefinition processName = null;
        try {
            Deployment bpelDeployment = BpelImportParser.parseBpelFromUrl((URL)bpelURL, wsdls);
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            processName = remoteDeployer.deploy(bpelDeployment);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception while deploying bpel from url : " + bpelURL, e);
        }
        return processName;
    }

    protected static void deploy(CommandLine line) {
        URL bpelFile = null;
        ArrayList<URL> wsdlUrls = new ArrayList<URL>();
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        if (line.hasOption("bpel")) {
            String bpelFileName = line.getOptionValue("bpel");
            try {
                bpelFile = new File(bpelFileName).toURL();
            }
            catch (MalformedURLException e) {
                throw new OrchestraRuntimeException("Invalid bpel file name " + bpelFileName, (Exception)e);
            }
        }
        if (line.hasOption("wsdls")) {
            String extWsdlCmd = line.getOptionValue("wsdls");
            for (String wsdl : extWsdlCmd.split(",")) {
                try {
                    wsdlUrls.add(new File(wsdl).toURL());
                }
                catch (MalformedURLException e) {
                    throw new OrchestraRuntimeException("Invalid wsdl file name " + wsdl, (Exception)e);
                }
            }
        }
        ProcessDefinition processName = DeployAction.deploy(bpelFile, wsdlUrls, jmxServiceUrl, jmxObjectName);
        System.out.println("Process " + processName.getUUID() + " deployed !");
    }

    @Override
    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        DeployAction.deploy(line);
        return true;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getDescription() {
        return "To deploy a BPEL process";
    }
}

