/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;

public class DeployBarAction
implements ClientAction {
    private Options options = ClientOptions.createDeployBarOptions();

    public static QName deployBar(URL barFile, String jmxServiceUrl, String jmxObjectName) {
        QName processName = null;
        byte[] barBytes = null;
        try {
            int c;
            InputStream stream = barFile.openStream();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            while ((c = stream.read()) != -1) {
                output.write(c);
            }
            stream.close();
            barBytes = output.toByteArray();
        }
        catch (Exception e) {
            throw new OrchestraException("couldn't read bar file from url " + barFile, e);
        }
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            processName = remoteDeployer.deployBar(barBytes);
        }
        catch (Exception e) {
            throw new OrchestraException("Exception while deploying barFile : " + barFile, e);
        }
        return processName;
    }

    public static QName deployBar(byte[] barBytes, String jmxServiceUrl, String jmxObjectName) {
        QName processName = null;
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            processName = remoteDeployer.deployBar(barBytes);
        }
        catch (Exception e) {
            throw new OrchestraException("Exception while deploying barFile ", e);
        }
        return processName;
    }

    protected static void deployBar(CommandLine line) {
        URL barFile = null;
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        if (line.hasOption("bar")) {
            String barFileName = line.getOptionValue("bar");
            try {
                barFile = new File(barFileName).toURL();
            }
            catch (MalformedURLException e) {
                throw new OrchestraException("Invalid bar url " + barFileName, (Exception)e);
            }
        }
        QName processName = DeployBarAction.deployBar(barFile, jmxServiceUrl, jmxObjectName);
        System.out.println("Process " + processName + " deployed !");
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        DeployBarAction.deployBar(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To deploy a BPEL process from a Bar";
    }
}

