package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;

public class InitAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createInitOptions();

  public static void init(String jmxServiceUrl, String jmxObjectName) {
    try {
      RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      remoteDeployer.initialize();
    } catch (Exception e) {
      throw new OrchestraException("Exception during initialization", e);
    }

  }

  protected static void init(CommandLine line) {
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    init(jmxServiceUrl, jmxObjectName);
    System.out.println("Orchestra is started and initialized");
  }

  public boolean parseAndExecute(String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    init(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To initialize Orchestra Engine (redeploy WS after a crash)";
  }
}
