/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;

public class InitAction
implements ClientAction {
    private Options options = ClientOptions.createInitOptions();

    public static void init(String jmxServiceUrl, String jmxObjectName) {
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            remoteDeployer.initialize();
        }
        catch (Exception e) {
            throw new OrchestraException("Exception during initialization", e);
        }
    }

    protected static void init(CommandLine line) {
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        InitAction.init(jmxServiceUrl, jmxObjectName);
        System.out.println("Orchestra is started and initialized");
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        InitAction.init(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To initialize Orchestra Engine (redeploy WS after a crash)";
    }
}

