package org.ow2.orchestra.jmxclient;

import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;

public class ListProcessAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createListOptions();

  public static List<QName> list(String jmxServiceUrl, String jmxObjectName) {
    try {
      RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      return remoteDeployer.listProcess();
    } catch (Exception e) {
      throw new OrchestraException(e);
    }

  }

  protected static void list(CommandLine line) {
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    List<QName> processNames = list(jmxServiceUrl, jmxObjectName);
    System.out.println("List of deployed processes :");
    for (QName name : processNames) {
      System.out.println(name);
    }
  }

  public boolean parseAndExecute(String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    list(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To list deployed BPEL processes";
  }
}
