/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.exception.OrchestraException;
import org.ow2.orchestra.jmx.ProcessInfo;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;

public class GetProcessAction
implements ClientAction {
    private Options options = ClientOptions.createGetProcessOptions();

    public static ProcessInfo get(String jmxServiceUrl, String jmxObjectName, QName processQName) {
        try {
            RemoteDeployerMBean mbean = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            ProcessInfo processInfo = new ProcessInfo();
            processInfo.setQname(processQName);
            return processInfo;
        }
        catch (Exception e) {
            throw new OrchestraException("Error while getting process info " + processQName.toString(), e);
        }
    }

    protected static void get(CommandLine line) {
        QName processQName = null;
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        if (line.hasOption("process")) {
            processQName = QName.valueOf(line.getOptionValue("process"));
        }
        ProcessInfo recProc = GetProcessAction.get(jmxServiceUrl, jmxObjectName, processQName);
        System.out.println("Informations of the deployed processes :");
        if (recProc != null) {
            System.out.println(recProc.getQname());
        }
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        GetProcessAction.get(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To get the informations of the deployed BPEL process";
    }
}

