package org.ow2.orchestra.jmxclient;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.ProcessInfo;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;

public class GetProcessAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createGetProcessOptions();

  public static ProcessInfo get(final String jmxServiceUrl, final String jmxObjectName, final QName processQName) {
    try {
      RemoteDeployerMBean mbean = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      ProcessInfo processInfo = new ProcessInfo();
      processInfo.setQname(processQName);
      return processInfo;
    } catch (Exception e) {
      throw new OrchestraRuntimeException("Error while getting process info " + processQName.toString(), e);
    }
  }

  protected static void get(final CommandLine line) {
    QName processQName = null;
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);
    if (line.hasOption(ClientOptions.PROCESS_QNAME_OPTION)) {
      processQName = QName.valueOf(line.getOptionValue(ClientOptions.PROCESS_QNAME_OPTION));
    }

    ProcessInfo recProc = get(jmxServiceUrl, jmxObjectName, processQName);
    System.out.println("Informations of the deployed processes :");
    if (recProc != null) {
      System.out.println(recProc.getQname());
    }
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    get(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To get the informations of the deployed BPEL process";
  }
}
