package org.ow2.orchestra.jmxclient;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.InstanceInfo;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;

public class ListInstanceAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createListInstanceOptions();

  public static Map<QName, List<InstanceInfo>> list(String jmxServiceUrl, String jmxObjectName) {
    try {
      RemoteDeployerMBean mbean = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      return mbean.listInstance();
    } catch (Exception e) {
      throw new OrchestraRuntimeException(e);
    }
  }

  protected static void list(CommandLine line) {
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    //get processQNames to be able to debug
    List<QName> processNames = ListProcessAction.list(jmxServiceUrl, jmxObjectName);
    Map<QName, List<InstanceInfo>> instances = list(jmxServiceUrl, jmxObjectName);
    System.out.println("Orchestra is started");
    System.out.println("List of running instances per process:");
    for (QName qName : processNames) {
      System.out.println("process QName = " + qName);
      List<InstanceInfo> insts = instances.get(qName);
      for (InstanceInfo instRec : insts) {
        System.out.println("instance uid = " + instRec.getInstanceUId() + " nodeName ="
            + instRec.getNodeName() + " state = " + instRec.getState());
      }
    }
  }

  public boolean parseAndExecute(String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    list(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To list BPEL instances";
  }
}
