package org.ow2.orchestra.jmxclient;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;

public class StatusAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createStatusOptions();

  protected static void status(CommandLine line) {
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    List<QName> processNames = ListProcessAction.list(jmxServiceUrl,
        jmxObjectName);
    RemoteDeployerMBean remoteDeployer = null;
    try {
      remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
    } catch (Exception e) {
      throw new OrchestraRuntimeException(e);
    }
    Map<QName, List<String>> instances = remoteDeployer.listInstanceStatus();
    System.out.println("Orchestra is started");
    System.out.println("List of deployed processes and running instances:");
    for (QName name : processNames) {
      System.out.println(name);
      System.out.println(instances.get(name));
    }

  }

  public boolean parseAndExecute(String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    status(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "get Orchestra status";
  }
}
