/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import javax.xml.soap.SOAPMessage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LaunchAction
implements ClientAction {
    private Options options = ClientOptions.createLaunchOptions();

    public static SOAPMessage launch(String endPoint, String soapAction, String soapMessage) {
        SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)soapAction, (String)soapMessage);
        SOAPMessage response = SOAPUtil.call((SOAPMessage)request, (String)endPoint);
        return response;
    }

    protected static void launch(CommandLine line) {
        String endpoint = null;
        String soapAction = null;
        String soapMessage = null;
        if (line.hasOption("endpoint")) {
            endpoint = line.getOptionValue("endpoint");
        } else {
            System.out.println("Error: endpoint should be defined.");
        }
        if (line.hasOption("soapAction")) {
            soapAction = line.getOptionValue("soapAction");
        } else {
            System.out.println("Error: soapAction should be defined.");
        }
        if (line.hasOption("soapMessage")) {
            soapMessage = line.getOptionValue("soapMessage");
        } else {
            System.out.println("Error: soapMessage should be defined.");
        }
        try {
            SOAPMessage response = LaunchAction.launch(endpoint, soapAction, soapMessage);
            if (response != null) {
                System.out.println("Message received: ");
                Node msg = (Node)response.getSOAPBody().getChildElements().next();
                if (msg instanceof Element) {
                    System.out.println(XmlUtil.toString((Element)((Element)response.getSOAPBody().getChildElements().next())));
                } else if (msg instanceof Text) {
                    System.out.println(msg.getNodeValue());
                } else {
                    System.out.println(msg.toString());
                }
            } else {
                System.out.println("Call done, no response.");
            }
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Error during WS call", e);
        }
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        LaunchAction.launch(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To invoke a web service";
    }
}

