/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.InstanceInfo;
import org.ow2.orchestra.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;
import org.ow2.orchestra.jmxclient.ListProcessAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListInstanceAction
implements ClientAction {
    private Options options = ClientOptions.createListInstanceOptions();

    public static Map<QName, List<InstanceInfo>> list(String jmxServiceUrl, String jmxObjectName) {
        try {
            RemoteDeployerMBean mbean = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            return mbean.listInstance();
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException(e);
        }
    }

    protected static void list(CommandLine line) {
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        List<QName> processNames = ListProcessAction.list(jmxServiceUrl, jmxObjectName);
        Map<QName, List<InstanceInfo>> instances = ListInstanceAction.list(jmxServiceUrl, jmxObjectName);
        System.out.println("Orchestra is started");
        System.out.println("List of running instances per process:");
        for (QName qName : processNames) {
            System.out.println("process QName = " + qName);
            List<InstanceInfo> insts = instances.get(qName);
            for (InstanceInfo instRec : insts) {
                System.out.println("instance uid = " + instRec.getInstanceUId() + " nodeName =" + instRec.getNodeName() + " state = " + instRec.getState());
            }
        }
    }

    @Override
    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        ListInstanceAction.list(line);
        return true;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public String getDescription() {
        return "To list BPEL instances";
    }
}

