package org.ow2.orchestra.jmxclient;

import javax.xml.soap.SOAPMessage;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jbpm.pvm.internal.util.XmlUtil;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.util.SOAPUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class LaunchAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createLaunchOptions();

  /**
   * Call a web service
   * 
   * @param endPoint
   *            url of the service
   * @param soapAction
   *            SOAP action of the operation
   * @param soapMessage
   *            SOAP message to send (without SOAP envelop)
   * @return result of the call
   */
  public static SOAPMessage launch(String endPoint, String soapAction,
      String soapMessage) {
    SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage(soapAction,
        soapMessage);
    SOAPMessage response = SOAPUtil.call(request, endPoint);
    return response;

  }

  /**
   * Call a web service
   * 
   * @param line
   *            parsed command line
   */
  protected static void launch(CommandLine line) {
    String endpoint = null;
    String soapAction = null;
    String soapMessage = null;

    if (line.hasOption(ClientOptions.WS_ENDPOINT_OPTION)) {
      endpoint = line.getOptionValue(ClientOptions.WS_ENDPOINT_OPTION);
    } else {
      System.out.println("Error: endpoint should be defined.");
    }
    if (line.hasOption(ClientOptions.SOAP_ACTION_OPTION)) {
      soapAction = line.getOptionValue(ClientOptions.SOAP_ACTION_OPTION);
    } else {
      System.out.println("Error: soapAction should be defined.");
    }
    if (line.hasOption(ClientOptions.SOAP_MSG_OPTION)) {
      soapMessage = line.getOptionValue(ClientOptions.SOAP_MSG_OPTION);
    } else {
      System.out.println("Error: soapMessage should be defined.");
    }
    try {
      SOAPMessage response = launch(endpoint, soapAction, soapMessage);
      if (response != null) {
        System.out.println("Message received: ");
        Node msg = (Node) response.getSOAPBody().getChildElements().next();
        if (msg instanceof Element) {
          System.out.println(XmlUtil.toString((Element) response.getSOAPBody().getChildElements().next()));
        } else if (msg instanceof Text) {
          System.out.println(msg.getNodeValue());
        } else {
          System.out.println(msg.toString());
        }
      } else {
        System.out.println("Call done, no response.");
      }
    } catch (Exception e) {
      throw new OrchestraRuntimeException("Error during WS call", e);
    }

  }

  public boolean parseAndExecute(String[] args) {
    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    launch(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To invoke a web service";
  }
}
