/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import java.io.IOException;
import java.util.ArrayList;
import javax.naming.ServiceUnavailableException;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.jmx.JMXConfiguration;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.DeployAction;
import org.ow2.orchestra.jmxclient.DeployBarAction;
import org.ow2.orchestra.jmxclient.GetProcessAction;
import org.ow2.orchestra.jmxclient.InitAction;
import org.ow2.orchestra.jmxclient.LaunchAction;
import org.ow2.orchestra.jmxclient.ListInstanceAction;
import org.ow2.orchestra.jmxclient.ListProcessAction;
import org.ow2.orchestra.jmxclient.StatusAction;
import org.ow2.orchestra.jmxclient.UndeployAction;

public final class JMXClient {
    protected static String jmxServiceUrl;
    protected static String jmxObjectName;

    private JMXClient() {
    }

    private static void printHelp(String description, Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("");
        System.out.println();
        System.out.println(description + ":");
        formatter.printHelp("java -jar orchestra-jmxclient.jar", opts, true);
        System.out.println();
    }

    public static void main(String[] args) {
        block14: {
            try {
                try {
                    jmxServiceUrl = JMXConfiguration.getInstance().getServiceUrl();
                    jmxObjectName = JMXConfiguration.getInstance().getObjectName();
                }
                catch (Exception e) {
                    throw new OrchestraRuntimeException("JMX Configuration error", e);
                }
                ArrayList<ClientAction> actions = new ArrayList<ClientAction>();
                actions.add(new DeployAction());
                actions.add(new DeployBarAction());
                actions.add(new UndeployAction());
                actions.add(new StatusAction());
                actions.add(new ListProcessAction());
                actions.add(new ListInstanceAction());
                actions.add(new GetProcessAction());
                actions.add(new LaunchAction());
                actions.add(new InitAction());
                if (System.getProperty("extraActionsClasses") != null) {
                    String extraActions = System.getProperty("extraActionsClasses");
                    for (String className : extraActions.split(",")) {
                        try {
                            Class<?> clazz = JMXClient.class.getClassLoader().loadClass(className);
                            Object o = clazz.newInstance();
                            actions.add((ClientAction)o);
                        }
                        catch (Exception e) {
                            throw new OrchestraRuntimeException("Error while creating action : " + className, e);
                        }
                    }
                }
                boolean done = false;
                for (ClientAction action : actions) {
                    if (!action.parseAndExecute(args)) continue;
                    done = true;
                }
                if (done) break block14;
                GnuParser parser = new GnuParser();
                try {
                    parser.parse(ClientOptions.createHelpOptions(), args);
                }
                catch (ParseException exp) {
                    StringBuffer strBuf = new StringBuffer();
                    strBuf.append("Error: invalid syntax '");
                    for (String arg : args) {
                        strBuf.append(" " + arg);
                    }
                    strBuf.append("'");
                    throw new OrchestraRuntimeException(strBuf.toString());
                }
                System.out.println("JmxClient for Nova Orchestra");
                System.out.println("List of possible actions:");
                for (ClientAction action : actions) {
                    JMXClient.printHelp(action.getDescription(), action.getOptions());
                }
            }
            catch (OrchestraRuntimeException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException && cause.getCause() instanceof ServiceUnavailableException) {
                    System.out.println("Error during connection. Please check that Orchestra is started.");
                }
                System.out.println("Operation failed : " + e.getMessage());
                throw e;
            }
        }
    }
}

