package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ListInstanceAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createListInstanceOptions();

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To list BPEL instances";
  }
}
