package org.ow2.orchestra.jmxclient;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;

public class ListProcessAction implements ClientAction {

  // create Options object
  private Options options = ClientOptions.createListOptions();

  public static List<QName> list(final String jmxServiceUrl, final String jmxObjectName) {
    try {
      RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      List<ProcessDefinition> processDefinitionDataList = remoteDeployer.findProcessDefinitions();
      List<QName> result = new ArrayList<QName>();
      for (ProcessDefinition processDefinitionData : processDefinitionDataList) {
        result.add(processDefinitionData.getQName());
      }
      return result;
    } catch (Exception e) {
      throw new OrchestraRuntimeException(e);
    }

  }

  protected static void list(final CommandLine line) {
    String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    List<QName> processNames = list(jmxServiceUrl, jmxObjectName);
    System.out.println("List of deployed processes :");
    for (QName name : processNames) {
      System.out.println(name);
    }
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(options, args);
    } catch (ParseException exp) {
      // oops, something went wrong
      return false;
    }

    list(line);

    return true;
  }

  public Options getOptions() {
    return options;
  }

  public String getDescription() {
    return "To list deployed BPEL processes";
  }
}
