/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.jmxclient;

import javax.xml.namespace.QName;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.novabpm.util.Misc;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.jmxclient.ClientAction;
import org.ow2.orchestra.jmxclient.ClientOptions;
import org.ow2.orchestra.jmxclient.JMXClient;

public class UndeployAction
implements ClientAction {
    private Options options = ClientOptions.createUndeployOptions();

    public static boolean undeploy(QName processQName, String jmxServiceUrl, String jmxObjectName) {
        boolean result = false;
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)jmxServiceUrl, (String)jmxObjectName);
            result = remoteDeployer.undeploy(processQName);
        }
        catch (Exception e) {
            throw new OrchestraRuntimeException("Exception caught while undeploying process : " + processQName, e);
        }
        return result;
    }

    protected static void undeploy(CommandLine line) {
        boolean result;
        QName processQName = null;
        String jmxServiceUrl = line.getOptionValue("jmxUrl", JMXClient.jmxServiceUrl);
        String jmxObjectName = line.getOptionValue("jmxObject", JMXClient.jmxObjectName);
        if (line.hasOption("process")) {
            processQName = QName.valueOf(line.getOptionValue("process"));
        }
        if (result = UndeployAction.undeploy(processQName, jmxServiceUrl, jmxObjectName)) {
            System.out.println("Process " + processQName + " undeployed !");
        } else {
            System.out.println("Problem during undeployment of process " + processQName);
        }
    }

    public boolean parseAndExecute(String[] args) {
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(this.options, args);
        }
        catch (ParseException exp) {
            return false;
        }
        UndeployAction.undeploy(line);
        return true;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getDescription() {
        return "To undeploy a BPEL process";
    }
}

