package org.ow2.orchestra.jmxclient;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.util.Misc;

public class ListProcessAction implements ClientAction {

  // create Options object
  private final Options options = ClientOptions.createListOptions();

  public static List<QName> list(final String jmxServiceUrl, final String jmxObjectName) {
    try {
      final RemoteDeployerMBean remoteDeployer = Misc.getMBeanProxy(RemoteDeployerMBean.class, jmxServiceUrl, jmxObjectName);
      final List<ProcessDefinition> processDefinitionDataList = remoteDeployer.findProcessDefinitions();
      final List<QName> result = new ArrayList<QName>();
      for (final ProcessDefinition processDefinitionData : processDefinitionDataList) {
        result.add(processDefinitionData.getQName());
      }
      return result;
    } catch (final Exception e) {
      throw new OrchestraRuntimeException(e);
    }
  }

  protected static void list(final CommandLine line) {
    final String jmxServiceUrl = line.getOptionValue(ClientOptions.JMX_URL_OPTION,
        JMXClient.jmxServiceUrl);
    final String jmxObjectName = line.getOptionValue(ClientOptions.JMX_OBJECT_OPTION,
        JMXClient.jmxObjectName);

    final List<QName> processNames = ListProcessAction.list(jmxServiceUrl, jmxObjectName);
    System.out.println("List of deployed processes :");
    for (final QName name : processNames) {
      System.out.println(name);
    }
  }

  public boolean parseAndExecute(final String[] args) {

    // create the parser
    final CommandLineParser parser = new GnuParser();
    CommandLine line = null;
    try {
      // parse the command line arguments
      line = parser.parse(this.options, args);
    } catch (final ParseException exp) {
      // oops, something went wrong
      return false;
    }

    ListProcessAction.list(line);

    return true;
  }

  public Options getOptions() {
    return this.options;
  }

  public String getDescription() {
    return "To list deployed BPEL processes";
  }
}
