package org.ow2.orchestra.jmxclient;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class ClientOptions {

  static final String HELP_OPTION = "help";

  static final String HELP_SHORT_OPTION = "h";

  static final String DEPLOY_OPTION = "deploy";

  static final String DEPLOY_SHORT_OPTION = "d";

  static final String UNDEPLOY_OPTION = "undeploy";

  static final String UNDEPLOY_SHORT_OPTION = "u";

  static final String LIST_OPTION = "list";

  static final String LIST_INSTANCE_OPTION = "listInstance";

  static final String LIST_SHORT_OPTION = "l";

  static final String GET_OPTION = "get";

  static final String GET_PROCESS_OPTION = "getProcess";

  static final String GET_SHORT_OPTION = "g";

  static final String STATUS_OPTION = "status";

  static final String STATUS_SHORT_OPTION = "s";

  static final String INIT_OPTION = "initialize";

  static final String INIT_SHORT_OPTION = "init";

  static final String LAUNCH_OPTION = "call";

  static final String LAUNCH_SHORT_OPTION = "c";

  static final String BPEL_OPTION = "bpel";

  static final String BPEL_SHORT_OPTION = "b";

  static final String BAR_OPTION = "bar";

  static final String WSDL_OPTION = "wsdls";

  static final String WSDL_SHORT_OPTION = "w";

  static final String JMX_URL_OPTION = "jmxUrl";

  static final String JMX_URL_SHORT_OPTION = "ju";

  static final String JMX_OBJECT_OPTION = "jmxObject";

  static final String JMX_OBJECT_SHORT_OPTION = "jo";

  static final String PROCESS_QNAME_OPTION = "process";

  static final String PROCESS_QNAME_SHORT_OPTION = "p";

  static final String WS_ENDPOINT_OPTION = "endpoint";

  static final String WS_ENDPOINT_SHORT_OPTION = "ws";

  static final String SOAP_ACTION_OPTION = "soapAction";

  static final String SOAP_ACTION_SHORT_OPTION = "a";

  static final String SOAP_MSG_OPTION = "soapMessage";

  static final String SOAP_MSG_SHORT_OPTION = "m";

  private ClientOptions() {
  }

  protected static Options createHelpOptions() {
    final Options options = new Options();

    // Create options
    final Option help = new Option(ClientOptions.HELP_SHORT_OPTION, ClientOptions.HELP_OPTION, false,
        "print this message");
    options.addOption(help);
    help.setRequired(true);

    return options;
  }

  protected static Options createDeployOptions() {
    final Options options = new Options();

    final Option deploy = new Option(ClientOptions.DEPLOY_SHORT_OPTION, ClientOptions.DEPLOY_OPTION, false,
        "deploy the process");
    deploy.setRequired(true);

    final Option bpelfile = new Option(ClientOptions.BPEL_SHORT_OPTION, ClientOptions.BPEL_OPTION, true,
        "use given bpel file");
    bpelfile.setArgName("file");
    bpelfile.setRequired(true);

    final Option wsdlFiles = new Option(ClientOptions.WSDL_SHORT_OPTION, ClientOptions.WSDL_OPTION, true,
        "use given wsdl files");
    wsdlFiles.setArgName("file,file,...");
    wsdlFiles.setValueSeparator(' ');

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(bpelfile);
    options.addOption(wsdlFiles);
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    // Only one action at the same time
    options.addOption(deploy);

    return options;
  }

  protected static Options createDeployBarOptions() {
    final Options options = new Options();

    final Option deploy = new Option(ClientOptions.DEPLOY_SHORT_OPTION, ClientOptions.DEPLOY_OPTION, false,
        "deploy the process");
    deploy.setRequired(true);

    final Option barfile = new Option(ClientOptions.BAR_OPTION, true, "use given bar file");
    barfile.setArgName("file");
    barfile.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(barfile);
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    // Only one action at the same time
    options.addOption(deploy);

    return options;
  }

  protected static Options createUndeployOptions() {
    final Options options = new Options();
    final Option undeploy = new Option(ClientOptions.UNDEPLOY_SHORT_OPTION, ClientOptions.UNDEPLOY_OPTION, false,
        "undeploy the process");
    undeploy.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    OptionBuilder
        .withArgName("name");
    OptionBuilder.withLongOpt(ClientOptions.PROCESS_QNAME_OPTION);
    OptionBuilder.hasArg();
    OptionBuilder.withDescription("name of the process");
    final Option processName = OptionBuilder.create(ClientOptions.PROCESS_QNAME_SHORT_OPTION);
    processName.setRequired(true);

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);
    options.addOption(processName);
    options.addOption(undeploy);

    return options;
  }

  protected static Options createGetProcessOptions() {
    final Options options = new Options();
    final Option getProcess = new Option(ClientOptions.GET_PROCESS_OPTION, false,
        "get info for the process");
    getProcess.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    OptionBuilder
        .withArgName("name");
    OptionBuilder.hasArg();
    OptionBuilder.withDescription("name of the process");
    OptionBuilder.withLongOpt(ClientOptions.PROCESS_QNAME_OPTION);
    final Option processName = OptionBuilder
        .create(ClientOptions.PROCESS_QNAME_SHORT_OPTION);
    processName.setRequired(true);

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);
    options.addOption(processName);
    options.addOption(getProcess);

    return options;
  }

  protected static Options createLaunchOptions() {
    final Options options = new Options();

    final Option launch = new Option(ClientOptions.LAUNCH_SHORT_OPTION, ClientOptions.LAUNCH_OPTION, false,
        "launch the process");
    launch.setRequired(true);

    OptionBuilder
        .withArgName("url");
    OptionBuilder.withLongOpt(ClientOptions.WS_ENDPOINT_OPTION);
    OptionBuilder.hasArg();
    OptionBuilder.withDescription("WS endpoint");
    final Option endpoint = OptionBuilder.create(
            ClientOptions.WS_ENDPOINT_SHORT_OPTION);

    OptionBuilder.hasArg();
    OptionBuilder.withDescription("WS SOAP Action");
    OptionBuilder.withLongOpt(ClientOptions.SOAP_ACTION_OPTION);
    OptionBuilder
        .withArgName("action");
    final Option soapAction = OptionBuilder
        .create(ClientOptions.SOAP_ACTION_SHORT_OPTION);

    OptionBuilder
        .withArgName("message");
    OptionBuilder.withLongOpt(ClientOptions.SOAP_MSG_OPTION);
    OptionBuilder.withDescription("WS SOAP Message");
    OptionBuilder.hasArg();
    final Option soapMessage = OptionBuilder
        .create(ClientOptions.SOAP_MSG_SHORT_OPTION);

    // Add options to the client
    options.addOption(endpoint);
    options.addOption(soapAction);
    options.addOption(soapMessage);

    options.addOption(launch);

    return options;
  }

  protected static Options createListOptions() {
    final Options options = new Options();

    final Option list = new Option(ClientOptions.LIST_SHORT_OPTION, ClientOptions.LIST_OPTION, false,
        "list deployed process");
    list.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createListInstanceOptions() {
    final Options options = new Options();

    final Option list = new Option(ClientOptions.LIST_INSTANCE_OPTION, false,
        "list deployed instances");
    list.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createStatusOptions() {
    final Options options = new Options();

    final Option list = new Option(ClientOptions.STATUS_SHORT_OPTION, ClientOptions.STATUS_OPTION, false,
        "get Orchestra status");
    list.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }

  protected static Options createInitOptions() {
    final Options options = new Options();

    final Option list = new Option(ClientOptions.INIT_SHORT_OPTION, ClientOptions.INIT_OPTION, false,
        "initialize orchestra engine");
    list.setRequired(true);

    final Option jmxServiceUrl = new Option(ClientOptions.JMX_URL_SHORT_OPTION, ClientOptions.JMX_URL_OPTION,
        true, "use given jmx service url");
    jmxServiceUrl.setArgName("url");

    final Option jmxObjectName = new Option(ClientOptions.JMX_OBJECT_SHORT_OPTION,
        ClientOptions.JMX_OBJECT_OPTION, true,
        "use given jmx objectName for the remote deployer");
    jmxObjectName.setArgName("objectName");

    // Add options to the client
    options.addOption(jmxServiceUrl);
    options.addOption(jmxObjectName);

    options.addOption(list);

    return options;
  }
}
